/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.utils;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import io.github.mortuusars.chalk.core.SymbolUnlocking;
import io.github.mortuusars.chalk.data.ChalkColors;
import io.github.mortuusars.chalk.network.Packets;
import io.github.mortuusars.chalk.network.packet.SelectSymbolS2CP;
import io.github.mortuusars.chalk.utils.MarkDrawHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkDrawingContext {
    @Nullable
    private static MarkDrawingContext storedContext;
    private final Player player;
    private final Level level;
    private final BlockHitResult hitResult;
    private final InteractionHand drawingHand;
    private final SymbolOrientation initialOrientation;

    public MarkDrawingContext(Player player, @NotNull BlockHitResult hitResult, InteractionHand drawingHand) {
        this.player = player;
        this.level = player.level();
        this.hitResult = hitResult;
        this.drawingHand = drawingHand;
        this.initialOrientation = SymbolOrientation.fromClickLocationAll(hitResult.getLocation(), hitResult.getDirection());
    }

    public static void storeContext(MarkDrawingContext context) {
        storedContext = context;
    }

    @Nullable
    public static MarkDrawingContext getStoredContext() {
        return storedContext;
    }

    public static void clearStoredContext() {
        storedContext = null;
    }

    public boolean canDraw() {
        return MarkDrawingContext.canBeDrawnOn(this.hitResult.getBlockPos(), this.getMarkFacing(), this.level);
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getMarkBlockPos() {
        return this.hitResult.getBlockPos().relative(this.getMarkFacing());
    }

    @NotNull
    public Direction getMarkFacing() {
        return this.hitResult.getDirection();
    }

    public SymbolOrientation getInitialOrientation() {
        return this.initialOrientation;
    }

    public InteractionHand getDrawingHand() {
        return this.drawingHand;
    }

    public void openSymbolSelectionScreen() {
        if (this.level.isClientSide) {
            MarkDrawingContext.storeContext(this);
            return;
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List<MarkSymbol> unlockedSymbols = SymbolUnlocking.getUnlockedSymbols(serverPlayer);
            if (!unlockedSymbols.isEmpty()) {
                Packets.sendToClient(serverPlayer, new SelectSymbolS2CP(unlockedSymbols), new CustomPacketPayload[0]);
            } else {
                this.player.displayClientMessage((Component)Component.translatable((String)"gui.chalk.no_symbols_unlocked").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    public Mark createRegularMark(int color, boolean glowing) {
        return this.createMark(color, this.getInitialOrientation() == SymbolOrientation.CENTER ? MarkSymbol.CENTER : MarkSymbol.ARROW, glowing);
    }

    public Mark createMark(int color, MarkSymbol symbol, boolean glowing) {
        Direction face = this.getMarkFacing();
        MarkSymbol.OrientationBehavior rotBehavior = symbol.getOrientationBehavior();
        SymbolOrientation orientation = rotBehavior == MarkSymbol.OrientationBehavior.FULL ? this.initialOrientation : (rotBehavior == MarkSymbol.OrientationBehavior.CARDINAL ? SymbolOrientation.fromClickLocationCardinal(this.hitResult.getLocation(), face) : (rotBehavior == MarkSymbol.OrientationBehavior.UP_DOWN_CARDINAL && (face == Direction.UP || face == Direction.DOWN) ? SymbolOrientation.fromRotation(this.player.getDirection().getOpposite().get2DDataValue() * 90) : symbol.getDefaultOrientation()));
        return new Mark(face, color, symbol, orientation, glowing);
    }

    public boolean hasExistingMark() {
        return this.level.getBlockState(this.hitResult.getBlockPos().relative(this.getMarkFacing())).getBlock() instanceof ChalkMarkBlock;
    }

    public boolean shouldMarkReplaceAnother(Mark mark) {
        BlockState oldMarkState = this.level.getBlockState(this.hitResult.getBlockPos().relative(this.getMarkFacing()));
        Block block = oldMarkState.getBlock();
        if (!(block instanceof ChalkMarkBlock)) {
            return true;
        }
        ChalkMarkBlock markBlock = (ChalkMarkBlock)block;
        if (mark.color != ChalkColors.fromDyeColor(markBlock.getColor())) {
            return true;
        }
        if (mark.facing != oldMarkState.getValue((Property)ChalkMarkBlock.FACING)) {
            return true;
        }
        if (mark.symbol != oldMarkState.getValue(ChalkMarkBlock.SYMBOL)) {
            return true;
        }
        if (mark.orientation != oldMarkState.getValue(ChalkMarkBlock.ORIENTATION)) {
            return true;
        }
        return mark.glowing && (Boolean)oldMarkState.getValue((Property)ChalkMarkBlock.GLOWING) == false;
    }

    public boolean draw(Mark mark) {
        ItemStack drawingItemstack = this.player.getItemInHand(this.drawingHand);
        return MarkDrawHelper.draw(this.player, this.level, this.getMarkBlockPos(), mark.createBlockState(drawingItemstack), mark.color, this.drawingHand);
    }

    private static boolean canBeDrawnOn(BlockPos pos, Direction face, Level level) {
        BlockState blockStateAtPos = level.getBlockState(pos);
        BlockState markPosState = level.getBlockState(pos.relative(face));
        return (markPosState.isAir() || markPosState.getBlock() instanceof ChalkMarkBlock) && Block.isFaceFull((VoxelShape)blockStateAtPos.getCollisionShape((BlockGetter)level, pos), (Direction)face) && !blockStateAtPos.is(Chalk.Tags.Blocks.CHALK_CANNOT_DRAW_ON);
    }
}

