/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.item.ChalkBoxItem;
import io.github.mortuusars.chalk.menu.ChalkBoxItemStackHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ChalkBoxMenu
extends AbstractContainerMenu {
    private final int chalkBoxSlotIndex;
    private final ChalkBoxItem chalkBoxItem;
    private final Player player;
    private final boolean glowingEnabled;

    public ChalkBoxMenu(int containerId, final Inventory playerInventory, final int chalkBoxSlotIndex) {
        super((MenuType)Chalk.Menus.CHALK_BOX.get(), containerId);
        ItemStack chalkBoxStack = playerInventory.getItem(chalkBoxSlotIndex);
        Preconditions.checkArgument((boolean)(chalkBoxStack.getItem() instanceof ChalkBoxItem), (String)"{} is not a ChalkBoxItem.", (Object)chalkBoxStack);
        this.chalkBoxSlotIndex = chalkBoxSlotIndex;
        this.chalkBoxItem = (ChalkBoxItem)chalkBoxStack.getItem();
        this.player = playerInventory.player;
        this.glowingEnabled = (Boolean)Config.Common.CHALK_BOX_GLOWING_ENABLED.get();
        int slotsYPos = this.glowingEnabled ? 18 : 33;
        ChalkBoxItemStackHandler itemHandler = new ChalkBoxItemStackHandler(chalkBoxStack){

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (ChalkBoxMenu.this.player.isCreative()) {
                    playerInventory.setItem(chalkBoxSlotIndex, this.getChalkBoxStack());
                }
            }
        };
        int index = 0;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 4; ++column) {
                if (index >= 8) {
                    throw new IllegalStateException("Chalk slot ids should go before Glowing Item slot id and not exceed it.");
                }
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, index++, column * 18 + 53, row * 18 + slotsYPos));
            }
        }
        if (this.glowingEnabled) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 8, 80, 68){

                public void set(@NotNull ItemStack stack) {
                    if (ChalkBoxMenu.this.player.level().isClientSide && this.getItem().isEmpty() && ChalkBoxMenu.this.getGlowAmount() <= 0 && stack.is(Chalk.Tags.Items.GLOWINGS)) {
                        Vec3 pos = ChalkBoxMenu.this.player.position();
                        ChalkBoxMenu.this.player.level().playSound(ChalkBoxMenu.this.player, pos.x, pos.y, pos.z, (SoundEvent)Chalk.SoundEvents.GLOW_APPLIED.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        ChalkBoxMenu.this.player.level().playSound(ChalkBoxMenu.this.player, pos.x, pos.y, pos.z, (SoundEvent)Chalk.SoundEvents.GLOWING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    super.set(stack);
                }
            });
        }
        this.addPlayerSlots(playerInventory);
    }

    protected void addPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                if (index == this.chalkBoxSlotIndex) {
                    this.addSlot(new Slot(this, (Container)playerInventory, index, column * 18 + 8, 98 + row * 18){

                        public boolean mayPlace(@NotNull ItemStack pStack) {
                            return false;
                        }

                        public boolean mayPickup(@NotNull Player pPlayer) {
                            return false;
                        }

                        public boolean isActive() {
                            return false;
                        }

                        public boolean isHighlightable() {
                            return false;
                        }
                    });
                    continue;
                }
                this.addSlot(new Slot((Container)playerInventory, index, column * 18 + 8, 98 + row * 18));
            }
        }
        for (int index = 0; index < 9; ++index) {
            if (index == this.chalkBoxSlotIndex) {
                this.addSlot(new Slot(this, (Container)playerInventory, index, index * 18 + 8, 156){

                    public boolean mayPlace(@NotNull ItemStack pStack) {
                        return false;
                    }

                    public boolean mayPickup(@NotNull Player pPlayer) {
                        return false;
                    }

                    public boolean isActive() {
                        return false;
                    }

                    public boolean isHighlightable() {
                        return false;
                    }
                });
                continue;
            }
            this.addSlot(new Slot((Container)playerInventory, index, index * 18 + 8, 156));
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        player.playSound((SoundEvent)Chalk.SoundEvents.CHALK_BOX_CLOSE.get(), 0.85f, 0.9f + player.level().random.nextFloat() * 0.2f);
        if (player.isCreative() && !player.level().isClientSide && this.chalkBoxSlotIndex >= 0) {
            player.getInventory().setItem(this.chalkBoxSlotIndex, this.getChalkBoxStack());
        }
        player.inventoryMenu.resumeRemoteUpdates();
    }

    public ItemStack getChalkBoxStack() {
        return this.player.getInventory().getItem(this.chalkBoxSlotIndex);
    }

    public boolean isGlowingEnabled() {
        return this.glowingEnabled;
    }

    public int getGlowAmount() {
        return this.chalkBoxItem.getGlowAmount(this.getChalkBoxStack());
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItemStack = slot.getItem();
            itemstack = slotItemStack.copy();
            if (index < 9 ? !this.moveItemStackTo(slotItemStack, 9, this.slots.size(), true) : !this.moveItemStackTo(slotItemStack, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItemStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.chalkBoxSlotIndex >= 0 && this.getChalkBoxStack().getItem().equals(this.chalkBoxItem);
    }

    public static ChalkBoxMenu fromBuffer(int containerID, Inventory playerInventory, RegistryFriendlyByteBuf buffer) {
        return new ChalkBoxMenu(containerID, playerInventory, buffer.readVarInt());
    }
}

