/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.core;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.core.MarkSymbol;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SymbolUnlocking {
    public static List<MarkSymbol> getUnlockedSymbols(ServerPlayer player) {
        ArrayList<MarkSymbol> unlocked = new ArrayList<MarkSymbol>();
        for (MarkSymbol symbol : MarkSymbol.getSpecialSymbols()) {
            try {
                String advancementLocation;
                Pair<ModConfigSpec.BooleanValue, ModConfigSpec.ConfigValue<String>> symbolConfig = Config.Common.SYMBOL_CONFIG.get((Object)symbol);
                if (!((Boolean)((ModConfigSpec.BooleanValue)symbolConfig.getFirst()).get()).booleanValue() || !(advancementLocation = (String)((ModConfigSpec.ConfigValue)symbolConfig.getSecond()).get()).isEmpty() && !SymbolUnlocking.hasAdvancement(player, ResourceLocation.parse((String)advancementLocation))) continue;
                unlocked.add(symbol);
            }
            catch (Exception e) {
                Chalk.LOGGER.error("Cannot check if the symbol '{}' is unlocked: {}", (Object)symbol, (Object)e.toString());
            }
        }
        return unlocked;
    }

    private static boolean hasAdvancement(ServerPlayer player, ResourceLocation advancementID) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            Chalk.LOGGER.error("Cannot check advancements: server is null");
            return false;
        }
        AdvancementHolder advancementHolder = server.getAdvancements().get(advancementID);
        if (advancementHolder == null) {
            return false;
        }
        AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancementHolder);
        return progress.isDone();
    }
}

