/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.core;

import com.mojang.serialization.Codec;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum MarkSymbol implements StringRepresentable
{
    CENTER("center", false, OrientationBehavior.FIXED, SymbolOrientation.NORTH),
    ARROW("arrow", false, OrientationBehavior.FULL, SymbolOrientation.NORTH),
    CROSS("cross", true, OrientationBehavior.FIXED, SymbolOrientation.NORTH),
    CHECKMARK("check", true, OrientationBehavior.UP_DOWN_CARDINAL, SymbolOrientation.NORTH),
    SKULL("skull", true, OrientationBehavior.UP_DOWN_CARDINAL, SymbolOrientation.NORTH),
    HOUSE("house", true, OrientationBehavior.UP_DOWN_CARDINAL, SymbolOrientation.NORTH),
    HEART("heart", true, OrientationBehavior.UP_DOWN_CARDINAL, SymbolOrientation.NORTH),
    PICKAXE("pickaxe", true, OrientationBehavior.UP_DOWN_CARDINAL, SymbolOrientation.NORTH);

    public static final Codec<MarkSymbol> CODEC;
    public static final IntFunction<MarkSymbol> BY_ID;
    public static final StreamCodec<ByteBuf, MarkSymbol> STREAM_CODEC;
    private final String name;
    private final ResourceLocation textureLocation;
    private final boolean isSpecial;
    private final OrientationBehavior orientationBehavior;
    private final SymbolOrientation defaultOrientation;

    private MarkSymbol(String name, boolean isSpecial, OrientationBehavior orientationBehavior, SymbolOrientation defaultOrientation) {
        this.name = name;
        this.textureLocation = Chalk.resource("block/mark/" + name);
        this.isSpecial = isSpecial;
        this.orientationBehavior = orientationBehavior;
        this.defaultOrientation = defaultOrientation;
    }

    public static List<MarkSymbol> getSpecialSymbols() {
        return Arrays.stream(MarkSymbol.values()).filter(s -> s.isSpecial).collect(Collectors.toList());
    }

    public static MarkSymbol byNameOrDefault(String name) {
        for (MarkSymbol symbol : MarkSymbol.values()) {
            if (!symbol.name.equals(name)) continue;
            return symbol;
        }
        return CENTER;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public OrientationBehavior getOrientationBehavior() {
        return this.orientationBehavior;
    }

    public SymbolOrientation getDefaultOrientation() {
        return this.defaultOrientation;
    }

    public String getTranslationKey() {
        return "gui.chalk.symbol." + this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(MarkSymbol::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MarkSymbol.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }

    public static enum OrientationBehavior implements StringRepresentable
    {
        FIXED("fixed"),
        FULL("full"),
        CARDINAL("cardinal"),
        UP_DOWN_CARDINAL("up_down_cardinal");

        private final String name;

        private OrientationBehavior(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

