/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.client.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.core.IChalkDrawingTool;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.data.ChalkColors;
import io.github.mortuusars.chalk.network.Packets;
import io.github.mortuusars.chalk.network.packet.DrawMarkC2SP;
import io.github.mortuusars.chalk.utils.MarkDrawingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolSelectScreen
extends Screen {
    private static final int SYMBOL_SIZE = 48;
    private static final int SYMBOL_SPACING = 10;
    private static final float SYMBOL_BORDER_THICKNESS = 2.0f;
    private static final int DEFAULT_SYMBOL_BORDER_COLOR = -14342875;
    private static final Map<MarkSymbol, ResourceLocation> SYMBOL_TEXTURES = new HashMap<MarkSymbol, ResourceLocation>();
    private final Player player;
    private final Level level;
    private final long openTimestamp;
    private final List<MarkSymbol> unlockedSymbols;
    private final MarkDrawingContext drawingContext;
    private final InteractionHand drawingHand;
    private final int color;
    private final float r;
    private final float g;
    private final float b;
    private final int hoverBorderColor;
    private final Direction markFacing;
    private final BlockState surfaceState;
    private int centerX;
    private int centerY;
    private int buttonsWidth;
    private int buttonsStartX;
    @Nullable
    private MarkSymbol hoveredSymbol;
    private boolean mouseWasReleased;

    public SymbolSelectScreen(List<MarkSymbol> unlockedSymbols, MarkDrawingContext context) {
        super((Component)Component.empty());
        int n;
        this.unlockedSymbols = unlockedSymbols;
        this.drawingContext = context;
        this.drawingHand = context.getDrawingHand();
        this.minecraft = Minecraft.getInstance();
        this.player = this.minecraft.player;
        Preconditions.checkArgument((this.player != null ? 1 : 0) != 0, (Object)"Player cannot be null.");
        this.level = this.player.level();
        this.openTimestamp = this.level.getGameTime();
        ItemStack itemInHand = this.minecraft.player.getItemInHand(this.drawingHand);
        Item item = itemInHand.getItem();
        if (item instanceof IChalkDrawingTool) {
            IChalkDrawingTool drawingTool = (IChalkDrawingTool)item;
            n = drawingTool.getMarkColorValue(itemInHand);
        } else {
            n = ChalkColors.fromDyeColor(DyeColor.WHITE);
        }
        this.color = n;
        this.r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(this.color & 0xFF) / 255.0f;
        this.hoverBorderColor = this.color + -16777216;
        this.markFacing = this.drawingContext.getMarkFacing();
        BlockPos surfacePos = this.drawingContext.getMarkBlockPos().relative(this.markFacing.getOpposite());
        this.surfaceState = this.minecraft.level != null ? this.minecraft.level.getBlockState(surfacePos) : Blocks.AIR.defaultBlockState();
    }

    protected void init() {
        if (!this.drawingContext.canDraw()) {
            this.close();
            return;
        }
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.buttonsWidth = !this.unlockedSymbols.isEmpty() ? 48 * this.unlockedSymbols.size() + 10 * (this.unlockedSymbols.size() - 1) : 48;
        this.buttonsStartX = this.centerX - this.buttonsWidth / 2;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        this.player.setPose(Pose.CROUCHING);
        if (this.player.getForcedPose() != Pose.CROUCHING) {
            this.player.setForcedPose(Pose.CROUCHING);
        }
        graphics.fillGradient(0, 0, this.width, this.height, 0x25000000, 0x45000000);
        super.render(graphics, mouseX, mouseY, pPartialTick);
        this.hoveredSymbol = null;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        for (int i = 0; i < this.unlockedSymbols.size(); ++i) {
            boolean isHovering;
            MarkSymbol symbol = this.unlockedSymbols.get(i);
            int x = this.buttonsStartX + 48 * i + 10 * i - 1;
            int y = this.centerY - 24;
            boolean bl = isHovering = mouseX >= x && mouseX <= x + 48 && mouseY >= y && mouseY <= y + 48;
            if (isHovering) {
                this.hoveredSymbol = symbol;
                this.player.displayClientMessage((Component)Component.translatable((String)symbol.getTranslationKey()), true);
            }
            this.drawSymbolButton(graphics, mouseX, mouseY, symbol, x, y, isHovering);
        }
        graphics.pose().popPose();
    }

    public void renderBackground(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    private void drawSymbolButton(GuiGraphics graphics, int mouseX, int mouseY, MarkSymbol symbol, int x, int y, boolean isHovering) {
        this.renderBlockSurface(graphics, mouseX, mouseY, x, y);
        int borderColor = isHovering ? this.hoverBorderColor : -14342875;
        graphics.fill((int)((float)x - 2.0f), y, x, y + 48, borderColor);
        graphics.fill(x, (int)((float)y - 2.0f), x + 48, y, borderColor);
        graphics.fill(x + 48, y, (int)((float)(x + 48) + 2.0f), y + 48, borderColor);
        graphics.fill(x, y + 48, x + 48, (int)((float)(y + 48) + 2.0f), borderColor);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)1.0f);
        RenderSystem.enableBlend();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x + 24.0f, (float)y + 24.0f, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)(symbol.getDefaultOrientation().getRotation() + (Integer)Config.Client.SYMBOL_ROTATION_OFFSETS.get((Object)symbol).get())));
        poseStack.translate((float)(-x) - 24.0f, (float)(-y) - 24.0f, 0.0f);
        poseStack.translate(0.0f, 0.0f, 100.0f);
        graphics.blit(SYMBOL_TEXTURES.get((Object)symbol), x, y, 48, 48, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
        graphics.fillGradient(x, y, x + 48, y + 48, 0x8FFFFFF, 0x25000000);
    }

    private void renderBlockSurface(GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupForFlatItems();
        PoseStack posestack1 = new PoseStack();
        posestack1.translate((float)x, (float)y, 0.0f);
        int xRot = 0;
        int yRot = 0;
        if (this.markFacing == Direction.UP) {
            xRot = -90;
        } else if (this.markFacing == Direction.DOWN) {
            xRot = 90;
        }
        if (this.markFacing == Direction.EAST) {
            yRot = 270;
        } else if (this.markFacing == Direction.NORTH) {
            yRot = 180;
        } else if (this.markFacing == Direction.WEST) {
            yRot = 90;
        }
        posestack1.translate(24.0f, 24.0f, 24.0f);
        posestack1.mulPose(Axis.XP.rotationDegrees((float)xRot - 0.1f));
        posestack1.mulPose(Axis.YP.rotationDegrees((float)yRot - 0.1f));
        posestack1.translate(-24.0f, -24.0f, -24.0f);
        posestack1.translate(0.0f, 48.0f, 0.0f);
        posestack1.scale(1.0f, -1.0f, 1.0f);
        posestack1.scale(48.0f, 48.0f, 48.0f);
        MultiBufferSource.BufferSource bufferSource = graphics.bufferSource();
        this.minecraft.getBlockRenderer().renderSingleBlock(this.surfaceState, posestack1, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
        RenderSystem.applyModelViewMatrix();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (Minecraft.getInstance().options.keyInventory.matches(pKeyCode, pScanCode)) {
            this.close();
            return true;
        }
        int key = pKeyCode - 48;
        if (key >= 1 && key <= Math.min(this.unlockedSymbols.size(), 9)) {
            this.tryDrawSymbol(this.unlockedSymbols.get(key - 1));
            this.close();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.mouseWasReleased && this.level.getGameTime() - this.openTimestamp < 4L) {
            this.mouseWasReleased = true;
            return true;
        }
        if (button == 0 || !this.mouseWasReleased) {
            this.tryDrawSymbol(this.hoveredSymbol);
        }
        this.close();
        return true;
    }

    private boolean tryDrawSymbol(MarkSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        return this.drawSymbol(symbol);
    }

    private boolean drawSymbol(@NotNull MarkSymbol symbol) {
        Mark mark = this.createMark(symbol, this.player.getItemInHand(this.drawingHand));
        if (this.drawingContext.canDraw() && (!this.drawingContext.hasExistingMark() || this.drawingContext.shouldMarkReplaceAnother(mark))) {
            Packets.sendToServer(new DrawMarkC2SP(mark.color, NbtUtils.writeBlockState((BlockState)mark.createBlockState(this.player.getItemInHand(this.drawingHand))), this.drawingContext.getMarkBlockPos(), this.drawingHand), new CustomPacketPayload[0]);
            this.player.swing(this.drawingHand);
            return true;
        }
        return false;
    }

    private Mark createMark(MarkSymbol symbol, ItemStack itemInHand) {
        Item item = itemInHand.getItem();
        if (!(item instanceof IChalkDrawingTool)) {
            throw new IllegalStateException("Item in hand is not IDrawingTool. [%s]".formatted(itemInHand));
        }
        IChalkDrawingTool drawingTool = (IChalkDrawingTool)item;
        return drawingTool.getMark(itemInHand, this.drawingContext, symbol);
    }

    public void close() {
        this.onClose();
    }

    public void onClose() {
        this.player.setForcedPose(null);
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    static {
        for (MarkSymbol symbol : MarkSymbol.getSpecialSymbols()) {
            SYMBOL_TEXTURES.put(symbol, Chalk.resource("textures/block/mark/" + symbol.getSerializedName() + ".png"));
        }
    }
}

