/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.item;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.mcreator.createstuffadditions.client.model.Modelcopper_exoskeleton;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.mcreator.createstuffadditions.network.CreateSaModVariables;
import net.mcreator.createstuffadditions.procedures.CopperExoskeletonBodyTickEventProcedure;
import net.mcreator.createstuffadditions.procedures.LocalizationHandlerProcedure;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class CopperExoskeletonItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 2);
                map.put(ArmorItem.Type.LEGGINGS, 5);
                map.put(ArmorItem.Type.CHESTPLATE, 6);
                map.put(ArmorItem.Type.HELMET, 2);
                map.put(ArmorItem.Type.BODY, 6);
            }), 9, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COPPER_INGOT)}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"create_sa:invisible"))), 0.0f, 0.0f);
            registerHelper.register(ResourceLocation.parse((String)"create_sa:copper_exoskeleton"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelcopper_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelcopper_exoskeleton.LAYER_LOCATION)).body, "left_arm", new Modelcopper_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelcopper_exoskeleton.LAYER_LOCATION)).leftArm, "right_arm", new Modelcopper_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelcopper_exoskeleton.LAYER_LOCATION)).rightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                armorModel.crouching = living.isShiftKeyDown();
                armorModel.riding = defaultModel.riding;
                armorModel.young = living.isBaby();
                return armorModel;
            }
        }, new Item[]{(Item)CreateSaModItems.COPPER_EXOSKELETON_CHESTPLATE.get()});
    }

    public CopperExoskeletonItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Chestplate
    extends CopperExoskeletonItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().stacksTo(1));
        }

        public boolean isBarVisible(ItemStack stack) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getBarWidth(ItemStack stack) {
            LocalPlayer entity;
            LocalPlayer localPlayer = entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
            if (entity != null) {
                if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") > CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) {
                    return 13;
                }
                return (int)(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") * (1.0 / CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) * 13.0);
            }
            return (int)(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") * 0.0 * 13.0);
        }

        public int getBarColor(ItemStack stack) {
            return 8361684;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            LocalPlayer entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
            int tagWater = 0;
            tagWater = (int)((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater");
            if (entity != null) {
                if (Screen.hasShiftDown()) {
                    list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString().replace("\u00a77", "\u00a7f")));
                    list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.water").getString() + " \u00a78" + tagWater + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                    list.add((Component)Component.literal((String)" "));
                    list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.copper_exoskeleton.desc").getString(), 0));
                    list.add((Component)Component.literal((String)" "));
                    list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.used").getString()));
                    list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.copper_exoskeleton.desc2").getString(), 1));
                } else {
                    list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString()));
                    list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.water").getString() + " \u00a78" + tagWater + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                }
            }
            super.appendHoverText(itemstack, context, list, flag);
        }

        public boolean isEnchantable(ItemStack stack) {
            return true;
        }

        public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
            return ResourceLocation.parse((String)"create_sa:textures/entities/copper_exoskeleton.png");
        }

        public boolean overrideOtherStackedOnMe(ItemStack localTool, ItemStack potentialFuel, Slot slot, ClickAction action, Player player, SlotAccess access) {
            if (localTool.getCount() > 1) {
                return false;
            }
            if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
                return false;
            }
            if (potentialFuel.getItem() == Items.WATER_BUCKET || potentialFuel.getItem() == Items.POTION || potentialFuel.getItem() == Items.WET_SPONGE) {
                if (((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") >= CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity) {
                    return false;
                }
                double fuelBonus = 0.0;
                if (Screen.hasControlDown()) {
                    int insertedAmount = potentialFuel.getCount();
                    ItemStack lcl_item = new ItemStack((ItemLike)Items.AIR);
                    if (potentialFuel.getItem() == Items.WATER_BUCKET) {
                        lcl_item = new ItemStack((ItemLike)Items.BUCKET);
                        fuelBonus = ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") + (double)(100 * potentialFuel.getCount());
                    } else if (potentialFuel.getItem() == Items.POTION) {
                        lcl_item = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                        fuelBonus = ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") + (double)(25 * potentialFuel.getCount());
                    } else {
                        lcl_item = new ItemStack((ItemLike)Items.SPONGE);
                        fuelBonus = ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") + (double)(50 * potentialFuel.getCount());
                    }
                    lcl_item.setCount(potentialFuel.getCount());
                    access.set(lcl_item);
                    potentialFuel.shrink(insertedAmount);
                } else {
                    if (potentialFuel.getItem() == Items.WATER_BUCKET) {
                        if (potentialFuel.getCount() == 1) {
                            access.set(new ItemStack((ItemLike)Items.BUCKET));
                        }
                        if (potentialFuel.getCount() > 1) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET));
                        }
                        fuelBonus = ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") + 100.0;
                    } else if (potentialFuel.getItem() == Items.POTION) {
                        if (potentialFuel.getCount() == 1) {
                            access.set(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                        }
                        if (potentialFuel.getCount() > 1) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                        }
                        fuelBonus = ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") + 25.0;
                    } else {
                        if (potentialFuel.getCount() == 1) {
                            access.set(new ItemStack((ItemLike)Items.SPONGE));
                        }
                        if (potentialFuel.getCount() > 1) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.SPONGE));
                        }
                        fuelBonus = ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") + 50.0;
                    }
                    potentialFuel.shrink(1);
                }
                double waterBonus = fuelBonus;
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)localTool, tag -> tag.putDouble("tagWater", waterBonus > CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity ? CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity : waterBonus));
                this.playSound(player, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.bucket.empty")));
                return true;
            }
            return false;
        }

        protected void playSound(Player player, SoundEvent soundEvent) {
            player.playSound(soundEvent, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.1f);
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                CopperExoskeletonBodyTickEventProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
            }
        }
    }
}

