/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.WhitePuffballBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;

class BWGProcessorRules {
    protected static final ProcessorRule[] FORGOTTEN_ROCKY_STONE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.ROCKY_STONE_SET.getBase(), 0.25f, BWGBlocks.MOSSY_STONE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.ROCKY_STONE_SET.getBase(), 0.25f, Blocks.GRAVEL), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.ROCKY_STONE_SET.getBase(), 0.25f, Blocks.STONE)};
    protected static final ProcessorRule FORGOTTEN_GRAVEL = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.GRAVEL, 0.35f, Blocks.SUSPICIOUS_GRAVEL);
    protected static final ProcessorRule FORGOTTEN_LUSH_GRASS_BLOCK = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), 0.45f, Blocks.MOSS_BLOCK);
    protected static final ProcessorRule[] FORGOTTEN_MOSSY_STONE_BRICKS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.MOSSY_STONE_BRICKS, 0.1f, Blocks.STONE_BRICKS), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.MOSSY_STONE_BRICKS, 0.2f, Blocks.CRACKED_STONE_BRICKS), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.MOSSY_STONE_BRICKS, 0.1f, Blocks.TUFF)};
    protected static final ProcessorRule[] DIRT_RANDOM_GRASS_COARSE_DIRT_PODZOL = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.DIRT, 0.25f, Blocks.GRASS_BLOCK), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.DIRT, 0.25f, Blocks.COARSE_DIRT), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.DIRT, 0.25f, Blocks.PODZOL)};
    protected static final ProcessorRule[] GRASS_RANDOM_DIRT_PODZOL_COARSE_DIRT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.GRASS_BLOCK, 0.25f, Blocks.DIRT), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.GRASS_BLOCK, 0.25f, Blocks.PODZOL), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.GRASS_BLOCK, 0.25f, Blocks.COARSE_DIRT)};
    protected static final ProcessorRule[] STONE_RANDOM_COBBLESTONE_MOSSY = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE, 0.15f, Blocks.COBBLESTONE), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE, 0.15f, Blocks.MOSSY_COBBLESTONE), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE, 0.15f, BWGBlocks.MOSSY_STONE_SET.getBase())};
    protected static final ProcessorRule[] MOSSIFY_70_PERCENT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE, 0.7f, BWGBlocks.MOSSY_STONE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.COBBLESTONE, 0.7f, Blocks.MOSSY_COBBLESTONE), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE_BRICKS, 0.7f, Blocks.MOSSY_STONE_BRICKS), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE_STAIRS, 0.7f, (Block)BWGBlocks.MOSSY_STONE_SET.getStairs()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.COBBLESTONE_STAIRS, 0.7f, Blocks.MOSSY_COBBLESTONE_STAIRS)};
    protected static final ProcessorRule[] SWEETBERRY_BLUEBERRY_50_PERCENT_RANDOM_AGE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SWEET_BERRY_BUSH, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(0))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SWEET_BERRY_BUSH, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SWEET_BERRY_BUSH, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(2))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SWEET_BERRY_BUSH, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.SWEET_BERRY_BUSH.defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(0))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.SWEET_BERRY_BUSH.defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.SWEET_BERRY_BUSH.defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(2))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.SWEET_BERRY_BUSH.defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(3)))};
    protected static final ProcessorRule MOSSIFY_10_PERCENT = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.COBBLESTONE, 0.1f, Blocks.MOSSY_COBBLESTONE);
    protected static final ProcessorRule[] WHITE_PUFFBALL_RANDOM_AGE = BWGProcessorRules.createEvenChanceAgeRules(BWGBlocks.WHITE_PUFFBALL.getBlock(), WhitePuffballBlock.AGE, 3);
    protected static final ProcessorRule[] PUMPKIN_RANDOM_AGE = BWGProcessorRules.createEvenChanceAgeRules(Blocks.PUMPKIN_STEM, StemBlock.AGE, 7);
    protected static final ProcessorRule STRIPPED_DARK_OAK_WOOD_35_PERCENT_DARK_OAK_PLANKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.DARK_OAK_PLANKS, 0.35f, Blocks.STRIPPED_DARK_OAK_WOOD);
    protected static final ProcessorRule STRIPPED_OAK_LOG_60_PERCENT_OAK_PLANKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STRIPPED_OAK_LOG, 0.6f, Blocks.OAK_PLANKS);
    protected static final ProcessorRule[] POLISHED_ANDESITE_RANDOM_ANDESITE_GRAVEL = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.POLISHED_ANDESITE, 0.3f, Blocks.ANDESITE), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.POLISHED_ANDESITE, 0.3f, Blocks.GRAVEL)};
    protected static final ProcessorRule[] STONE_SLAB_RANDOM_ANDESITE_ROCKY_SLAB = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE_SLAB, 0.33f, (BlockState)Blocks.ANDESITE_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE_SLAB, 0.33f, (BlockState)BWGBlocks.ROCKY_STONE_SET.getSlab().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM))};
    protected static final ProcessorRule[] STONE_RANDOM_ROCKY_ANDESITE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE, 0.33f, Blocks.ANDESITE), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE, 0.33f, BWGBlocks.ROCKY_STONE_SET.getBase())};
    protected static final ProcessorRule[] ORANGE_TERRACOTTA_TO_RED_ROCK_CRACKED_RED_ROCK_BRICKS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.ORANGE_TERRACOTTA, 0.33f, BWGBlocks.RED_ROCK_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.ORANGE_TERRACOTTA, 0.33f, BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.ORANGE_TERRACOTTA, 0.1f, BWGBlocks.RED_ROCK_BRICKS_SET.getBase())};
    protected static final ProcessorRule RED_ROCK_BRICKS_TO_ORANGE_TERRACOTTA = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_BRICKS_SET.getBase(), 0.33f, Blocks.ORANGE_TERRACOTTA);
    protected static final ProcessorRule RED_ROCK_CRACKED_BRICKS_50_PERCENT_MOSSY_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase(), 0.5f, BWGBlocks.MOSSY_RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule STRIPPED_BAOBAB_WOOD_50_PERCENT_BAOBAB_PLANKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGWood.BAOBAB.strippedWood(), 0.5f, BWGWood.BAOBAB.planks());
    protected static final ProcessorRule RED_ROCK_25_PERCENT_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_SET.getBase(), 0.25f, BWGBlocks.RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule RED_ROCK_25_PERCENT_CRACKED_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_SET.getBase(), 0.25f, BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule RED_ROCK_BRICKS_35_PERCENT_CRACKED_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_BRICKS_SET.getBase(), 0.35f, BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule[] RANDOM_DESERT_POTTED_PLANT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.POTTED_CACTUS, 0.1f, Blocks.POTTED_DEAD_BUSH), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.POTTED_CACTUS, 0.2f, BWGBlocks.PRICKLY_PEAR_CACTUS.getPottedBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.POTTED_CACTUS, 0.2f, BWGBlocks.MINI_CACTUS.getPottedBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.POTTED_CACTUS, 0.2f, BWGBlocks.GOLDEN_SPINED_CACTUS.getPottedBlock())};
    protected static final ProcessorRule WHITE_DACITE_10_PERCENT_COBBLED_WHITE_DACITE = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.1f, BWGBlocks.WHITE_DACITE_COBBLESTONE_SET.getBase());
    protected static final ProcessorRule[] WHITE_DACITE_VARIANTS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.3f, BWGBlocks.WHITE_DACITE_COBBLESTONE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.3f, BWGBlocks.WHITE_DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.1f, BWGBlocks.CRACKED_WHITE_DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.1f, BWGBlocks.MOSSY_WHITE_DACITE_BRICKS_SET.getBase())};
    protected static final ProcessorRule[] DACITE_COBBLESTONE_VARIANTS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.1f, BWGBlocks.DACITE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.25f, BWGBlocks.DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.1f, BWGBlocks.CRACKED_DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.1f, BWGBlocks.MOSSY_DACITE_BRICKS_SET.getBase())};
    protected static final ProcessorRule[] SHORT_GRASS_TO_FLOWER_PUMPKIN_PATCH = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.15f, (Block)BWGBlocks.LEAF_PILE.get()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.15f, (Block)BWGBlocks.CLOVER_PATCH.get()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.1f, BWGBlocks.WHITE_ANEMONE.getBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.1f, BWGBlocks.CROCUS.getBlock())};
    protected static final ProcessorRule[] SHORT_GRASS_TO_FLOWER_SWAMP = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.15f, BWGBlocks.PEACH_LEATHER_FLOWER.getBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.15f, (Block)BWGBlocks.CLOVER_PATCH.get()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.1f, BWGBlocks.VIOLET_LEATHER_FLOWER.getBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.SHORT_GRASS, 0.1f, Blocks.MOSS_CARPET)};
    protected static final ProcessorRule[] STONEBRICKS_VARIANTS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE_BRICKS, 0.3f, Blocks.MOSSY_STONE_BRICKS), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE_BRICKS, 0.3f, Blocks.CRACKED_STONE_BRICKS), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.STONE_BRICKS, 0.3f, BWGBlocks.MOSSY_STONE_SET.getBase())};
    protected static final ProcessorRule PODZOL_25_PERCENT_COARSE_DIRT = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.PODZOL, 0.25f, Blocks.COARSE_DIRT);
    protected static final ProcessorRule PODZOL_10_PERCENT_GRAVEL = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.PODZOL, 0.1f, Blocks.GRAVEL);
    protected static final ProcessorRule[] PODZOL_10_PERCENT_ANDESITE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.PODZOL, 0.1f, Blocks.ANDESITE), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.PODZOL, 0.1f, Blocks.POLISHED_ANDESITE)};
    protected static final ProcessorRule PODZOL_50_PERCENT_LUSH_GRASS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.PODZOL, 0.5f, (Block)BWGBlocks.LUSH_GRASS_BLOCK.get());
    protected static final ProcessorRule BOG_TRIAL_FLOOR = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.PALE_MUD_BRICKS_SET.getBase(), 0.5f, BWGBlocks.PACKED_PALE_MUD.get());

    BWGProcessorRules() {
    }

    protected static ProcessorRule[] createEvenChanceAgeRules(Block block, IntegerProperty ageProperty, int maxAge) {
        float chance = 1.0f / (float)maxAge;
        ProcessorRule[] rules = new ProcessorRule[maxAge];
        for (int i = 1; i <= maxAge; ++i) {
            rules[i - 1] = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(block, chance, (BlockState)block.defaultBlockState().setValue((Property)ageProperty, (Comparable)Integer.valueOf(i)));
        }
        return rules;
    }

    protected static ProcessorRule burrowToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.PUMPKIN_BURROW.get(), chance, newBlock);
    }

    protected static ProcessorRule lushPathToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_DIRT_PATH.get(), chance, newBlock);
    }

    protected static ProcessorRule lushGrassToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), chance, newBlock);
    }

    protected static ProcessorRule tuffToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.TUFF, chance, newBlock);
    }

    protected static ProcessorRule grassBlockToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.GRASS_BLOCK, chance, newBlock);
    }

    protected static ProcessorRule chestToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.CHEST, chance, newBlock);
    }

    protected static ProcessorRule lushDirtToCoarseDirt(float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_DIRT_PATH.get(), chance, Blocks.COARSE_DIRT);
    }

    protected static ProcessorRule lushFarmLandToBlock(Block block, float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_FARMLAND.get(), chance, block);
    }

    protected static ProcessorRule streetWater(Block path, Block waterReplacement) {
        return new ProcessorRule((RuleTest)new BlockMatchTest(path), (RuleTest)new BlockMatchTest(Blocks.WATER), waterReplacement.defaultBlockState());
    }

    protected static ProcessorRule skyrisLeavesToGreenAppleLeaves(float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGWood.SKYRIS.leaves(), chance, (Block)BWGWood.SKYRIS_LEAVES_GREEN_APPLE.get());
    }

    protected static ProcessorRule skyrisLeavesToFlowering(float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGWood.SKYRIS.leaves(), chance, (Block)BWGWood.FLOWERING_SKYRIS_LEAVES.get());
    }

    protected static ProcessorRule spiritLeavesToFlowering(float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGWood.SPIRIT_LEAVES.get(), chance, (BlockState)BWGWood.FLOWERING_SPIRIT_LEAVES.get().defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
    }

    protected static ProcessorRule airToBlock(Block block, float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.AIR, chance, block);
    }

    private static ProcessorRule createAlwaysTrueRandomBlockMatchTest(Block start, float chance, Block newBlock) {
        return BWGProcessorRules.createProcessorRule(BWGProcessorRules.createRandomBlockMatchTest(start, chance), AlwaysTrueTest.INSTANCE, newBlock.defaultBlockState());
    }

    private static ProcessorRule createAlwaysTrueRandomBlockMatchTest(Block start, float chance, BlockState newBlock) {
        return BWGProcessorRules.createProcessorRule(BWGProcessorRules.createRandomBlockMatchTest(start, chance), AlwaysTrueTest.INSTANCE, newBlock);
    }

    private static RandomBlockMatchTest createRandomBlockMatchTest(Block block, float chance) {
        return new RandomBlockMatchTest(block, chance);
    }

    private static ProcessorRule createProcessorRule(RandomBlockMatchTest test, AlwaysTrueTest alwaysTrueTest, BlockState blockState) {
        return new ProcessorRule((RuleTest)test, (RuleTest)alwaysTrueTest, blockState);
    }
}

