/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;

public class GoToClosestVillage {
    public static BehaviorControl<PumpkinWarden> create(float speedModifier, int closeEnoughDist) {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, memoryAccessor -> (serverLevel, pumpkinWarden, l) -> {
            if (serverLevel.isVillage(pumpkinWarden.blockPosition())) {
                return false;
            }
            PoiManager poiManager = serverLevel.getPoiManager();
            int j = poiManager.sectionsToVillage(SectionPos.of((BlockPos)pumpkinWarden.blockPosition()));
            Vec3 vec3 = null;
            for (int k = 0; k < 5; ++k) {
                Vec3 vec32 = LandRandomPos.getPos((PathfinderMob)pumpkinWarden, (int)15, (int)7, blockPos -> -poiManager.sectionsToVillage(SectionPos.of((BlockPos)blockPos)));
                if (vec32 == null) continue;
                int m = poiManager.sectionsToVillage(SectionPos.of((BlockPos)BlockPos.containing((Position)vec32)));
                if (m < j) {
                    vec3 = vec32;
                    break;
                }
                if (m != j) continue;
                vec3 = vec32;
            }
            if (vec3 != null) {
                memoryAccessor.set((Object)new WalkTarget(vec3, speedModifier, closeEnoughDist));
            }
            return true;
        }));
    }
}

