/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.config.configs;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CommentedCodec;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.config.ConfigUtils;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldTreePlacedFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGVanillaPlacedFeatures;
import org.jetbrains.annotations.NotNull;

public record BWGWorldGenConfig(Map<ResourceKey<Biome>, Boolean> enabledBiomes, int regionWeight, boolean vanillaAdditions, Map<ResourceKey<PlacedFeature>, Boolean> vanillaFeatures) {
    private static final Path PATH = PlatformHandler.PLATFORM_HANDLER.configPath().resolve("world_generation.json5");
    @NotNull
    public static Supplier<BWGWorldGenConfig> INSTANCE = Suppliers.memoize(BWGWorldGenConfig::getOrCreateConfigFromDisk);
    private static final Codec<BWGWorldGenConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CommentedCodec.of((Codec)Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.BIOME), (Codec)Codec.BOOL), (String)"enabled_biomes", (String)"Which biomes are enabled, if disabled the biome will default to its vanilla counterpart for the given region").orElse(BWGWorldGenConfig.getDefaultBiomes()).forGetter(BWGWorldGenConfig::enabledBiomes), (App)CommentedCodec.of((Codec)Codec.INT, (String)"region_weight", (String)"How much each BWG region weighs. This weight applies to all 3 BWG Regions").orElse((Object)8).forGetter(BWGWorldGenConfig::regionWeight), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"vanilla_additions", (String)"Whether to add bwg flowers and features to Vanilla Biomes (Config Option for Fabric Only)").orElse((Object)true).forGetter(config -> true), (App)CommentedCodec.of((Codec)Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.PLACED_FEATURE), (Codec)Codec.BOOL), (String)"enabled_vanilla_additions", (String)"BWG Features that we add to Vanilla Biomes").orElse(BWGWorldGenConfig.getVanillaPlacedFeatureAdditions()).forGetter(BWGWorldGenConfig::vanillaFeatures)).apply((Applicative)instance, BWGWorldGenConfig::new));

    private static BWGWorldGenConfig createDefault() {
        return new BWGWorldGenConfig((Map<ResourceKey<Biome>, Boolean>)BWGWorldGenConfig.getDefaultBiomes(), 8, true, (Map<ResourceKey<PlacedFeature>, Boolean>)BWGWorldGenConfig.getVanillaPlacedFeatureAdditions());
    }

    @NotNull
    private static Object2BooleanMap<ResourceKey<Biome>> getDefaultBiomes() {
        Object2BooleanOpenHashMap enabledBiomes = new Object2BooleanOpenHashMap();
        for (ResourceKey<Biome> biomeResourceKey : BWGBiomes.BIOME_FACTORIES.keySet()) {
            enabledBiomes.put(biomeResourceKey, true);
        }
        enabledBiomes.replace(BWGBiomes.ERODED_BOREALIS, false);
        return enabledBiomes;
    }

    @NotNull
    private static Object2BooleanMap<ResourceKey<PlacedFeature>> getVanillaPlacedFeatureAdditions() {
        Object2BooleanOpenHashMap enabledFeatures = new Object2BooleanOpenHashMap();
        enabledFeatures.put(BWGVanillaPlacedFeatures.FLOWER_DEFAULT, true);
        enabledFeatures.put(BWGVanillaPlacedFeatures.FLOWER_PLAINS, true);
        enabledFeatures.put(BWGVanillaPlacedFeatures.FOREST_FLOWERS, true);
        enabledFeatures.put(BWGVanillaPlacedFeatures.FLOWER_WARM, true);
        enabledFeatures.put(BWGOverworldTreePlacedFeatures.PALM_TREES, true);
        return enabledFeatures;
    }

    private static BWGWorldGenConfig getOrCreateConfigFromDisk() {
        return ConfigUtils.loadConfig(PATH, CODEC, BWGWorldGenConfig.createDefault());
    }
}

