/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.item.filling;

import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import com.teamabnormals.blueprint.core.util.item.filling.IItemCategoryFiller;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class AlphabeticalItemCategoryFiller
implements IItemCategoryFiller {
    private final Predicate<Item> shouldInclude;

    public AlphabeticalItemCategoryFiller(Predicate<Item> shouldInclude) {
        this.shouldInclude = shouldInclude;
    }

    public static <I extends Item> AlphabeticalItemCategoryFiller forClass(Class<I> clazz) {
        return new AlphabeticalItemCategoryFiller(clazz::isInstance);
    }

    @Override
    public void fillItem(Item item, CreativeModeTab group, NonNullList<ItemStack> items) {
        if (ItemStackUtil.isAllowedInTab(item, group)) {
            ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)item);
            if (location != null) {
                String itemName = location.m_135815_();
                int insert = -1;
                Predicate<Item> shouldInclude = this.shouldInclude;
                for (int i = 0; i < items.size(); ++i) {
                    Item next = ((ItemStack)items.get(i)).m_41720_();
                    if (!shouldInclude.test(next)) continue;
                    ResourceLocation nextName = ForgeRegistries.ITEMS.getKey((Object)next);
                    if (nextName == null || itemName.compareTo(nextName.m_135815_()) > 0) {
                        insert = i + 1;
                        continue;
                    }
                    if (insert != -1) break;
                    insert += i + 1;
                }
                if (insert == -1) {
                    items.add((Object)new ItemStack((ItemLike)item));
                } else {
                    items.add(insert, (Object)new ItemStack((ItemLike)item));
                }
            } else {
                items.add((Object)new ItemStack((ItemLike)item));
            }
        }
    }
}

