/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class BlueprintRabbitTypes {
    private static final Set<BlueprintRabbitType> RABBIT_TYPES = new ObjectArraySet();

    public static synchronized BlueprintRabbitType register(int id, ResourceLocation name, ResourceLocation texturePath) {
        BlueprintRabbitType type = new BlueprintRabbitType(id, name, texturePath);
        RABBIT_TYPES.add(type);
        return type;
    }

    public static synchronized BlueprintRabbitType register(int id, ResourceLocation name) {
        return BlueprintRabbitTypes.register(id, name, new ResourceLocation(name.m_135827_(), "textures/entity/rabbit/" + name.m_135815_() + ".png"));
    }

    public static ImmutableList<BlueprintRabbitType> values() {
        return ImmutableList.copyOf(RABBIT_TYPES);
    }

    public record BlueprintRabbitType(int id, ResourceLocation name, ResourceLocation textureLocation) {
    }
}

