/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.savage_and_ravage.client.model.CreepieModel;
import com.teamabnormals.savage_and_ravage.client.model.ExecutionerModel;
import com.teamabnormals.savage_and_ravage.client.model.GrieferArmorModel;
import com.teamabnormals.savage_and_ravage.client.model.GrieferModel;
import com.teamabnormals.savage_and_ravage.client.model.IceologerModel;
import com.teamabnormals.savage_and_ravage.client.model.MaskOfDishonestyModel;
import com.teamabnormals.savage_and_ravage.client.model.RunePrisonModel;
import com.teamabnormals.savage_and_ravage.client.model.SkeletonVillagerModel;
import com.teamabnormals.savage_and_ravage.client.model.TricksterModel;
import com.teamabnormals.savage_and_ravage.client.model.VillagerArmorModel;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.BurningBannerRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.CreepieRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.ExecutionerRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.GrieferRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.IceChunkRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.IceologerRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.MischiefArrowRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.NoModelRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.RunePrisonRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.SkeletonVillagerRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.SporeBombRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.TricksterRenderer;
import com.teamabnormals.savage_and_ravage.client.renderer.entity.layers.TotemShieldLayer;
import com.teamabnormals.savage_and_ravage.core.SRConfig;
import com.teamabnormals.savage_and_ravage.core.data.server.modifiers.SRAdvancementModifierProvider;
import com.teamabnormals.savage_and_ravage.core.data.server.modifiers.SRBiomeModifierProvider;
import com.teamabnormals.savage_and_ravage.core.data.server.modifiers.SRLootModifierProvider;
import com.teamabnormals.savage_and_ravage.core.data.server.tags.SRBiomeTagsProvider;
import com.teamabnormals.savage_and_ravage.core.data.server.tags.SRBlockTagsProvider;
import com.teamabnormals.savage_and_ravage.core.data.server.tags.SREntityTypeTagsProvider;
import com.teamabnormals.savage_and_ravage.core.data.server.tags.SRItemTagsProvider;
import com.teamabnormals.savage_and_ravage.core.other.SRCompat;
import com.teamabnormals.savage_and_ravage.core.other.SRDataProcessors;
import com.teamabnormals.savage_and_ravage.core.other.SRDataSerializers;
import com.teamabnormals.savage_and_ravage.core.other.SRFeatures;
import com.teamabnormals.savage_and_ravage.core.other.SRModelLayers;
import com.teamabnormals.savage_and_ravage.core.registry.SRAttributes;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRItems;
import com.teamabnormals.savage_and_ravage.core.registry.SRLootConditions;
import com.teamabnormals.savage_and_ravage.core.registry.SRMobEffects;
import com.teamabnormals.savage_and_ravage.core.registry.SRParticleTypes;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.entity.EvokerRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="savage_and_ravage")
public class SavageAndRavage {
    public static final String MOD_ID = "savage_and_ravage";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("savage_and_ravage");

    public SavageAndRavage() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        SRDataProcessors.registerTrackedData();
        REGISTRY_HELPER.register(bus);
        SREntityTypes.ENTITIES.register(bus);
        SRParticleTypes.PARTICLES.register(bus);
        SRMobEffects.MOB_EFFECTS.register(bus);
        SRFeatures.FEATURES.register(bus);
        SRFeatures.SRConfiguredFeatures.CONFIGURED_FEATURES.register(bus);
        SRFeatures.SRPlacedFeatures.PLACED_FEATURES.register(bus);
        SRAttributes.ATTRIBUTES.register(bus);
        SRDataSerializers.SERIALIZERS.register(bus);
        SRLootConditions.LOOT_CONDITION_TYPES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayers);
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerModels);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SRConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SRConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SREntityTypes.registerEntitySpawns();
            SREntityTypes.registerWaveMembers();
            SRFeatures.registerPools();
            SRCompat.registerCompat();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(SRItems::registerItemProperties);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        SRBlockTagsProvider blockTags = new SRBlockTagsProvider(generator, existingFileHelper);
        generator.m_236039_(includeServer, (DataProvider)blockTags);
        generator.m_236039_(includeServer, (DataProvider)new SRItemTagsProvider(generator, blockTags, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new SREntityTypeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new SRBiomeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(includeServer, (DataProvider)new SRAdvancementModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new SRLootModifierProvider(generator));
        generator.m_236039_(includeServer, SRBiomeModifierProvider.create(generator, existingFileHelper));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayers(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer renderer = event.getRenderer(EntityType.f_20568_);
        if (renderer instanceof EvokerRenderer) {
            EvokerRenderer evokerRenderer = (EvokerRenderer)renderer;
            evokerRenderer.m_115326_(new TotemShieldLayer(evokerRenderer, event.getEntityModels()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerModels(ModelEvent.RegisterAdditional event) {
        event.register(IceChunkRenderer.MODEL_LOCATION);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SRModelLayers.CREEPIE, () -> CreepieModel.createBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(SRModelLayers.CREEPIE_ARMOR, () -> CreepieModel.createBodyLayer(new CubeDeformation(2.0f)));
        event.registerLayerDefinition(SRModelLayers.EXECUTIONER, ExecutionerModel::createBodyLayer);
        event.registerLayerDefinition(SRModelLayers.GRIEFER, GrieferModel::createBodyLayer);
        event.registerLayerDefinition(SRModelLayers.GRIEFER_ARMOR, GrieferArmorModel::createArmorLayer);
        event.registerLayerDefinition(SRModelLayers.ICEOLOGER, IceologerModel::createBodyLayer);
        event.registerLayerDefinition(SRModelLayers.ILLAGER_ARMOR, () -> TotemShieldLayer.createBodyLayer(new CubeDeformation(2.0f)));
        event.registerLayerDefinition(SRModelLayers.MASK_OF_DISHONESTY, MaskOfDishonestyModel::createArmorLayer);
        event.registerLayerDefinition(SRModelLayers.RUNE_PRISON, RunePrisonModel::createBodyLayer);
        event.registerLayerDefinition(SRModelLayers.SKELETON_VILLAGER, SkeletonVillagerModel::createBodyLayer);
        event.registerLayerDefinition(SRModelLayers.TRICKSTER, TricksterModel::createBodyLayer);
        event.registerLayerDefinition(SRModelLayers.VILLAGER_INNER_ARMOR, VillagerArmorModel::createInnerArmorLayer);
        event.registerLayerDefinition(SRModelLayers.VILLAGER_OUTER_ARMOR, VillagerArmorModel::createOuterArmorLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SREntityTypes.SKELETON_VILLAGER.get(), SkeletonVillagerRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.CREEPIE.get(), CreepieRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.GRIEFER.get(), GrieferRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.ICEOLOGER.get(), IceologerRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.EXECUTIONER.get(), ExecutionerRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.TRICKSTER.get(), TricksterRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.BURNING_BANNER.get(), BurningBannerRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.SPORE_CLOUD.get(), NoModelRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.SPORE_BOMB.get(), SporeBombRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.MISCHIEF_ARROW.get(), MischiefArrowRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.ICE_CHUNK.get(), IceChunkRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.ICE_CLOUD.get(), NoModelRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.RUNE_PRISON.get(), RunePrisonRenderer::new);
        event.registerEntityRenderer((EntityType)SREntityTypes.CONFUSION_BOLT.get(), NoModelRenderer::new);
    }
}

