/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.ai.goal;

import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.savage_and_ravage.core.mixin.RaiderAccessor;
import com.teamabnormals.savage_and_ravage.core.other.SRDataProcessors;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ImprovedCrossbowGoal<T extends PathfinderMob & CrossbowAttackMob>
extends Goal {
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedChanger;
    private final float radiusSq;
    private int seeTime;
    private int wait;
    private final double blocksUntilBackupSq;
    private int ticksTillSearch;
    private int practisingTicks;
    private BlockPos blockPos;
    private Vec3 blockPosVector;
    private Vec3 blockPosVectorCentred;

    public ImprovedCrossbowGoal(T mob, double speedChanger, float radius, double blocksUntilBackup) {
        this.mob = mob;
        this.speedChanger = speedChanger;
        this.radiusSq = radius * radius;
        this.blocksUntilBackupSq = blocksUntilBackup;
        this.ticksTillSearch = this.ticksTillSearch((PathfinderMob)this.mob);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean hasCrossbowOnMainHand() {
        return this.mob.m_21205_().m_41720_() instanceof CrossbowItem;
    }

    private boolean hasAttackTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public boolean m_8036_() {
        if (this.hasCrossbowOnMainHand()) {
            if (this.hasAttackTarget()) {
                return true;
            }
            if (this.noCelebrationAndNoRaid()) {
                if (this.practisingTicks > 0) {
                    return true;
                }
                if (this.ticksTillSearch > 0) {
                    --this.ticksTillSearch;
                    return false;
                }
                this.ticksTillSearch = this.ticksTillSearch((PathfinderMob)this.mob);
                return this.findNearestBlock();
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return this.hasAttackTarget() || this.practisingTicks > 0 && this.isValidTarget((LevelReader)((PathfinderMob)this.mob).f_19853_, this.blockPos) && this.noCelebrationAndNoRaid();
    }

    public void m_8056_() {
        super.m_8056_();
        this.practisingTicks = 200 + this.mob.m_217043_().m_188503_(160);
        if (this.blockPos != null) {
            this.blockPosVector = new Vec3((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_());
            this.blockPosVectorCentred = this.blockPosVector.m_82520_(0.5, 0.5, 0.5);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
        }
        this.practisingTicks = 0;
    }

    public void m_8037_() {
        boolean shouldMoveTowardsEnemy;
        int distanceCoefficient;
        boolean canSeeEnemy;
        LivingEntity target = this.mob.m_5448_();
        if (this.practisingTicks > 0) {
            --this.practisingTicks;
        }
        if (((Boolean)TrackedDataManager.INSTANCE.getValue(this.mob, SRDataProcessors.TARGET_HIT)).booleanValue()) {
            TrackedDataManager.INSTANCE.setValue(this.mob, SRDataProcessors.CELEBRATION_TIME, (Object)(100 + this.mob.m_217043_().m_188503_(100)));
            TrackedDataManager.INSTANCE.setValue(this.mob, SRDataProcessors.TARGET_HIT, (Object)false);
            this.practisingTicks = 0;
        }
        if (target == null && this.practisingTicks <= 0) {
            return;
        }
        boolean bl = canSeeEnemy = target != null ? this.mob.m_21574_().m_148306_((Entity)target) : this.canSeeTargetBlock();
        if (canSeeEnemy) {
            ++this.seeTime;
        } else {
            if (target == null) {
                this.practisingTicks = 0;
                return;
            }
            this.seeTime = 0;
        }
        this.mob.m_21561_(true);
        double distanceSq = target != null ? this.mob.m_20280_((Entity)target) : this.mob.m_20275_((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_());
        double distance = Mth.m_14116_((float)((float)distanceSq));
        int n = distanceCoefficient = target == null ? 2 : 1;
        if (distance <= this.blocksUntilBackupSq * (double)distanceCoefficient && (!(target instanceof AbstractVillager) || this.hasFirework()) && this.isWalkable()) {
            this.mob.m_21566_().m_24988_(this.mob.m_6117_() ? -0.5f : -3.0f, 0.0f);
        }
        ItemStack activeStack = this.mob.m_21211_();
        boolean bl2 = shouldMoveTowardsEnemy = (distanceSq > (double)this.radiusSq * (double)distanceCoefficient || this.seeTime < 5) && this.wait == 0;
        if (shouldMoveTowardsEnemy) {
            double speedChange;
            double d = speedChange = this.isCrossbowUncharged() ? this.speedChanger : this.speedChanger * 0.5;
            if (target != null) {
                this.mob.m_21573_().m_5624_((Entity)target, speedChange);
            } else {
                this.mob.m_21573_().m_26519_((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_(), speedChange);
            }
        } else {
            this.mob.m_21573_().m_26573_();
        }
        if (target != null) {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        } else {
            this.mob.m_21563_().m_24950_((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_(), 30.0f, 30.0f);
        }
        if (this.crossbowState == CrossbowState.UNCHARGED && !CrossbowItem.m_40932_((ItemStack)activeStack)) {
            if (canSeeEnemy) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                this.crossbowState = CrossbowState.CHARGING;
                ((CrossbowAttackMob)this.mob).m_6136_(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            int i;
            if (!this.mob.m_6117_()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)activeStack) || CrossbowItem.m_40932_((ItemStack)activeStack)) {
                this.mob.m_21253_();
                this.crossbowState = CrossbowState.CHARGED;
                this.wait = 20 + this.mob.m_217043_().m_188503_(20);
                if (this.mob.m_21206_().m_41720_() instanceof FireworkRocketItem) {
                    this.mob.m_6672_(InteractionHand.OFF_HAND);
                }
                ((CrossbowAttackMob)this.mob).m_6136_(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.wait;
            if (this.wait == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && canSeeEnemy) {
            this.performRangedAttack(target != null ? target.m_20182_() : this.blockPosVector.m_82520_(0.5, 0.0, 0.5));
            CrossbowItem.m_40884_((ItemStack)this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem)), (boolean)false);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private boolean noCelebrationAndNoRaid() {
        if (this.mob instanceof Raider) {
            return ((ServerLevel)((PathfinderMob)this.mob).f_19853_).m_8832_(this.mob.m_20183_()) == null && (Boolean)this.mob.m_20088_().m_135370_(((RaiderAccessor)this.mob).getIsCelebrating()) == false;
        }
        return true;
    }

    private boolean isWalkable() {
        PathNavigation pathnavigator = this.mob.m_21573_();
        NodeEvaluator nodeprocessor = pathnavigator.m_26575_();
        return nodeprocessor.m_8086_((BlockGetter)((PathfinderMob)this.mob).f_19853_, Mth.m_14107_((double)(this.mob.m_20185_() + 1.0)), Mth.m_14107_((double)this.mob.m_20186_()), Mth.m_14107_((double)(this.mob.m_20189_() + 1.0))) == BlockPathTypes.WALKABLE;
    }

    protected boolean findNearestBlock() {
        int hDiameter = 16;
        int vDiameter = 8;
        BlockPos pos = this.mob.m_20183_();
        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
        int y = 0;
        while (y <= vDiameter) {
            for (int hDist = 0; hDist < hDiameter; ++hDist) {
                int x = 0;
                while (x <= hDist) {
                    int z;
                    int n = z = x < hDist && x > -hDist ? hDist : 0;
                    while (z <= hDist) {
                        searchPos.m_122154_((Vec3i)pos, x, y - 1, z);
                        if (this.mob.m_21444_((BlockPos)searchPos) && this.isValidTarget((LevelReader)((PathfinderMob)this.mob).f_19853_, (BlockPos)searchPos)) {
                            this.blockPos = searchPos;
                            return true;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        return false;
    }

    protected int ticksTillSearch(PathfinderMob creature) {
        return 1000 + creature.m_217043_().m_188503_(1200);
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        return pos != null && world.m_8055_(pos).m_60713_(Blocks.f_50716_);
    }

    private boolean canSeeTargetBlock() {
        ((PathfinderMob)this.mob).f_19853_.m_46473_().m_6180_("canSee");
        Vec3 mobPos = new Vec3(this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        BlockHitResult result = ((PathfinderMob)this.mob).f_19853_.m_45547_(new ClipContext(mobPos, this.blockPosVectorCentred, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.mob));
        boolean canSee = result.m_82425_().equals((Object)this.blockPos) || result.m_6662_() == HitResult.Type.MISS;
        ((PathfinderMob)this.mob).f_19853_.m_46473_().m_7238_();
        return canSee;
    }

    private boolean isCrossbowUncharged() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    private boolean hasFirework() {
        if (this.mob.m_21206_().m_41720_() == Items.f_42688_) {
            return true;
        }
        for (ItemStack projectileStack : CrossbowItem.m_40941_((ItemStack)this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem)))) {
            if (projectileStack.m_41720_() != Items.f_42688_) continue;
            return true;
        }
        return false;
    }

    private void performRangedAttack(Vec3 targetPos) {
        InteractionHand hand = ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem);
        ItemStack weapon = this.mob.m_21120_(hand);
        if (this.mob.m_21093_(stack -> stack.m_41720_() instanceof CrossbowItem)) {
            this.performShooting(((PathfinderMob)this.mob).f_19853_, this.mob, targetPos, hand, weapon);
        }
        ((CrossbowAttackMob)this.mob).m_5847_();
    }

    private void performShooting(Level world, T shooter, Vec3 targetPos, InteractionHand hand, ItemStack weapon) {
        List projectiles = CrossbowItem.m_40941_((ItemStack)weapon);
        float[] soundPitches = CrossbowItem.m_220023_((RandomSource)this.mob.m_217043_());
        for (int i = 0; i < Math.min(projectiles.size(), 3); ++i) {
            float yaw;
            ItemStack projectileStack = (ItemStack)projectiles.get(i);
            if (projectileStack.m_41619_() || world.m_5776_()) continue;
            float f = i == 0 ? 0.0f : (yaw = i == 1 ? -10.0f : 10.0f);
            if (this.hasAttackTarget() && projectileStack.m_41720_() != Items.f_42688_) {
                CrossbowItem.m_40894_((Level)world, shooter, (InteractionHand)hand, (ItemStack)weapon, (ItemStack)projectileStack, (float)soundPitches[i], (boolean)false, (float)1.6f, (float)(14 - ((PathfinderMob)shooter).f_19853_.m_46791_().m_19028_() * 4), (float)yaw);
                continue;
            }
            Projectile shot = this.shootProjectile(world, shooter, targetPos, hand, weapon, projectileStack, soundPitches[i], yaw);
            if (i != 0) continue;
            TrackedDataManager.INSTANCE.setValue((Entity)shot, SRDataProcessors.CROSSBOW_OWNER, Optional.of(this.mob.m_20148_()));
        }
        CrossbowItem.m_40905_((Level)world, shooter, (ItemStack)weapon);
    }

    private Projectile shootProjectile(Level world, T shooter, Vec3 targetPos, InteractionHand hand, ItemStack weapon, ItemStack projectileStack, float soundPitch, float yaw) {
        boolean isFirework = projectileStack.m_41720_() == Items.f_42688_;
        FireworkRocketEntity projectile = isFirework ? new FireworkRocketEntity(world, projectileStack, shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true) : CrossbowItem.m_40914_((Level)world, shooter, (ItemStack)weapon, (ItemStack)projectileStack);
        this.shootCrossbowProjectile(shooter, targetPos, (Projectile)projectile, yaw, isFirework);
        weapon.m_41622_(isFirework ? 3 : 1, shooter, s -> s.m_21190_(hand));
        world.m_7967_((Entity)projectile);
        world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        return projectile;
    }

    private void shootCrossbowProjectile(T shooter, Vec3 targetPos, Projectile projectile, float yaw, boolean isFirework) {
        double x = targetPos.m_7096_() - shooter.m_20185_();
        double z = targetPos.m_7094_() - shooter.m_20189_();
        double distance = Mth.m_14116_((float)((float)(x * x + z * z)));
        double y = isFirework ? targetPos.m_7098_() + 1.0 - projectile.m_20186_() : this.getYIntoBox(targetPos.m_7098_()) - projectile.m_20186_() + distance * (double)0.2f;
        Vector3f vector3f = ((CrossbowAttackMob)shooter).m_32332_(shooter, new Vec3(x, y, z), yaw);
        projectile.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), 1.6f, (float)(14 - ((PathfinderMob)shooter).f_19853_.m_46791_().m_19028_() * 4));
        shooter.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (shooter.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    private double getYIntoBox(double y) {
        LivingEntity target = this.mob.m_5448_();
        return y + (target != null ? (double)target.m_20206_() * 0.3333333333333333 : -0.5);
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

