/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin;

import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.knockback.ConfigurableKnockback;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements ConfigurableKnockback {
    private float customKnockbackMultiplier_BetterCombat = 1.0f;

    @Inject(method={"getAttributeValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void getAttributeValue_Inject(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        LivingEntityMixin object = this;
        if (object instanceof Player) {
            Player player = (Player)object;
            int comboCount = ((PlayerAttackProperties)player).getComboCount();
            if (player.f_19853_.f_46443_ && comboCount > 0 && PlayerAttackHelper.shouldAttackWithOffHand(player, comboCount)) {
                PlayerAttackHelper.offhandAttributes(player, () -> {
                    double value = player.m_21204_().m_22181_(attribute);
                    cir.setReturnValue((Object)value);
                });
                cir.cancel();
            }
        }
    }

    @Override
    public void setKnockbackMultiplier_BetterCombat(float value) {
        this.customKnockbackMultiplier_BetterCombat = value;
    }

    @ModifyVariable(method={"takeKnockback"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public double takeKnockback_HEAD_changeStrength(double knockbackStrength) {
        return knockbackStrength * (double)this.customKnockbackMultiplier_BetterCombat;
    }
}

