/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.config.FallbackConfig;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.utils.PatternMatching;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;

public class WeaponAttributesFallback {
    public static void initialize() {
        FallbackConfig config = (FallbackConfig)BetterCombat.fallbackConfig.value;
        block0: for (ResourceLocation itemId : Registry.f_122827_.m_6566_()) {
            Item item = (Item)Registry.f_122827_.m_7745_(itemId);
            if (!WeaponAttributesFallback.hasAttributeModifier(item, Attributes.f_22281_) || PatternMatching.matches(itemId.toString(), config.blacklist_item_id_regex)) continue;
            for (FallbackConfig.CompatibilitySpecifier fallbackOption : config.fallback_compatibility) {
                AttributesContainer container;
                if (WeaponRegistry.getAttributes(itemId) != null || !PatternMatching.matches(itemId.toString(), fallbackOption.item_id_regex) || (container = WeaponRegistry.containers.get(new ResourceLocation(fallbackOption.weapon_attributes))) == null) continue;
                WeaponRegistry.resolveAndRegisterAttributes(itemId, container);
                continue block0;
            }
        }
    }

    private static boolean hasAttributeModifier(Item item, Attribute searchedAttribute) {
        ResourceLocation searchedAttributeId = Registry.f_122866_.m_7981_((Object)searchedAttribute);
        Multimap attributes = item.m_7167_(EquipmentSlot.MAINHAND);
        for (Map.Entry entry : attributes.entries()) {
            Attribute attribute = (Attribute)entry.getKey();
            ResourceLocation attributeId = Registry.f_122866_.m_7981_((Object)attribute);
            if (!attributeId.equals((Object)searchedAttributeId)) continue;
            return true;
        }
        return false;
    }
}

