/*
 * Decompiled with CFR 0.152.
 */
package com.amuzil.omegasource.dragonenchants.util;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class DragonUtils {
    public static boolean isArrowInBlock(Level level, float detectionRadius, Arrow arrow) {
        return level.m_186434_((Entity)arrow, arrow.m_20191_().m_82400_((double)detectionRadius)).iterator().hasNext();
    }

    public static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static boolean teleportRandomly(Level world, LivingEntity entity, double radiusMult) {
        double d0 = entity.f_19854_ + (world.f_46441_.m_188500_() - 0.5) * radiusMult;
        double d1 = entity.f_19855_ + ((double)world.f_46441_.m_188503_((int)radiusMult) - radiusMult / 2.0);
        double d2 = entity.f_19856_ + (world.f_46441_.m_188500_() - 0.5) * radiusMult;
        return DragonUtils.teleport(world, entity, d0, d1, d2, SoundEvents.f_11852_);
    }

    public static boolean teleport(Level world, LivingEntity entity, double x, double y, double z, SoundEvent sound) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > world.m_141937_() && !world.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = world.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)entity, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = entity.m_20182_();
            boolean flag2 = entity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                world.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)entity));
                if (!entity.m_20067_()) {
                    world.m_6263_((Player)null, entity.f_19854_, entity.f_19855_, entity.f_19856_, SoundEvents.f_11852_, entity.m_5720_(), 1.0f, 1.0f);
                    entity.m_5496_(sound, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public CompoundTag getNBTData(Entity entity) {
        return entity.m_20240_(new CompoundTag());
    }
}

