/*
 * Decompiled with CFR 0.152.
 */
package com.amuzil.omegasource.dragonenchants.enchants.weapon.sword;

import com.amuzil.omegasource.dragonenchants.enchants.DragonEnchantment;
import com.amuzil.omegasource.dragonenchants.enchants.DragonEnchantments;
import com.amuzil.omegasource.dragonenchants.util.DamageHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChainLightning
extends DragonEnchantment {
    public ChainLightning() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, DragonEnchantments.HANDS);
    }

    public int m_6586_() {
        return 4;
    }

    public int m_6183_(int pLevel) {
        return pLevel * 15 + 5;
    }

    public int m_6175_(int pLevel) {
        return super.m_6175_(pLevel) + 10;
    }

    public void m_7677_(@Nonnull LivingEntity pAttacker, @Nonnull Entity pTarget, int pLevel) {
        if (pTarget instanceof LivingEntity) {
            LivingEntity hit = (LivingEntity)pTarget;
            Level world = pAttacker.m_9236_();
            ArrayList<LivingEntity> previousTargets = new ArrayList<LivingEntity>();
            this.damageEntity(world, pLevel, pAttacker, hit);
            LivingEntity toAdd = hit;
            int maxTargets = pLevel + 1;
            for (int i = 0; i < maxTargets && toAdd != null; ++i) {
                previousTargets.add(toAdd);
                toAdd = this.affectNearbyTargets(previousTargets, pLevel, world, pAttacker);
            }
            if (previousTargets.size() > 1 && world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                for (int j = 0; j < previousTargets.size() - 1; ++j) {
                    LivingEntity first = (LivingEntity)previousTargets.get(j);
                    LivingEntity second = (LivingEntity)previousTargets.get(j + 1);
                    Vec3 pos = first.m_20182_().m_82520_(0.0, (double)hit.m_20192_() * 0.675, 0.0);
                    Vec3 pos2 = second.m_20182_().m_82520_(0.0, (double)hit.m_20192_() * 0.675, 0.0);
                    Vec3 diff = pos2.m_82546_(pos);
                    int h = 0;
                    while ((float)h < first.m_20270_((Entity)second)) {
                        Vec3 spawnPos = pos.m_82549_(diff.m_82490_((double)((float)h / first.m_20270_((Entity)second))));
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175827_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 8 + pLevel * 2, 0.0, 0.0, 0.0, 0.0125);
                        ++h;
                    }
                }
            }
        }
    }

    public LivingEntity affectNearbyTargets(List<LivingEntity> previousTargets, int enchLevel, Level world, LivingEntity attacker) {
        LivingEntity target = previousTargets.get(previousTargets.size() - 1);
        AABB box = target.m_20191_().m_82400_((double)(enchLevel + 2));
        List targets = world.m_6443_(LivingEntity.class, box, livingEntity -> !previousTargets.contains(livingEntity) && DamageHelper.canDamage((Entity)livingEntity, (Entity)attacker));
        LivingEntity hit = null;
        if (!targets.isEmpty()) {
            hit = (LivingEntity)targets.get(0);
            this.damageEntity(world, enchLevel, attacker, hit);
        }
        return hit;
    }

    public void damageEntity(Level world, int enchLevel, LivingEntity attacker, LivingEntity hit) {
        Vec3 pos = hit.m_20182_().m_82520_(0.0, (double)hit.m_20192_() * 0.675, 0.0);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123815_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 6 + enchLevel * 2, 0.0, 0.0, 0.0, 0.125);
            world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12089_, SoundSource.PLAYERS, 0.5f + (float)enchLevel / 10.0f, 0.8f + world.f_46441_.m_188501_() / 10.0f);
        }
        DamageSource source = DamageSource.f_19306_;
        source = source.m_19380_();
        source = source.m_19389_();
        hit.m_6469_(source, (float)enchLevel);
        hit.m_20254_(enchLevel);
        hit.m_5997_(world.f_46441_.m_188583_() / 4.0, world.f_46441_.m_188500_() / 10.0, world.f_46441_.m_188583_() / 4.0);
    }
}

