/*
 * Decompiled with CFR 0.152.
 */
package com.amuzil.omegasource.dragonenchants.enchants;

import com.amuzil.omegasource.dragonenchants.enchants.Devour;
import com.amuzil.omegasource.dragonenchants.enchants.DragonEnchantment;
import com.amuzil.omegasource.dragonenchants.enchants.armour.boots.EndWalker;
import com.amuzil.omegasource.dragonenchants.enchants.armour.chest.Eternal;
import com.amuzil.omegasource.dragonenchants.enchants.armour.chest.FrostHeart;
import com.amuzil.omegasource.dragonenchants.enchants.armour.helm.Enderference;
import com.amuzil.omegasource.dragonenchants.enchants.armour.leggings.WindStep;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.CriticalSunder;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.Venomous;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.WaterAspect;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.axe.Berserk;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.axe.Obliterate;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.blades.TrueEdge;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.bow.Detonate;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.bow.EndStep;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.bow.Homing;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.sword.Aftershock;
import com.amuzil.omegasource.dragonenchants.enchants.weapon.sword.ChainLightning;
import com.amuzil.omegasource.dragonenchants.util.DamageHelper;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DragonEnchantments {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"dragonenchants");
    public static final EnchantmentCategory WEAPONS = EnchantmentCategory.create((String)"weapons", item -> item instanceof SwordItem || item instanceof BowItem || item instanceof AxeItem || item instanceof CrossbowItem || item instanceof TridentItem);
    public static final EnchantmentCategory AXES = EnchantmentCategory.create((String)"axes", item -> item instanceof AxeItem);
    public static final EnchantmentCategory BLADES = EnchantmentCategory.create((String)"blades", item -> item instanceof SwordItem || item instanceof AxeItem);
    public static final EnchantmentCategory BOWS = EnchantmentCategory.create((String)"bows", item -> item instanceof BowItem || item instanceof CrossbowItem);
    public static final EquipmentSlot[] HANDS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    public static final EquipmentSlot[] ALL = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final RegistryObject<DragonEnchantment> AFTERSHOCK = ENCHANTMENTS.register("aftershock", Aftershock::new);
    public static final RegistryObject<DragonEnchantment> BERSERK = ENCHANTMENTS.register("berserk", Berserk::new);
    public static final RegistryObject<DragonEnchantment> CHAIN_LIGHTNING = ENCHANTMENTS.register("chain_lightning", ChainLightning::new);
    public static final RegistryObject<DragonEnchantment> CRITICAL_SUNDER = ENCHANTMENTS.register("critical_sunder", CriticalSunder::new);
    public static final RegistryObject<DragonEnchantment> DETONATE = ENCHANTMENTS.register("detonate", Detonate::new);
    public static final RegistryObject<DragonEnchantment> DEVOUR = ENCHANTMENTS.register("devour", Devour::new);
    public static final RegistryObject<DragonEnchantment> ENDERFERENCE = ENCHANTMENTS.register("enderference", Enderference::new);
    public static final RegistryObject<DragonEnchantment> END_STEP = ENCHANTMENTS.register("end_step", EndStep::new);
    public static final RegistryObject<DragonEnchantment> END_WALKER = ENCHANTMENTS.register("end_walker", EndWalker::new);
    public static final RegistryObject<DragonEnchantment> ETERNAL = ENCHANTMENTS.register("eternal", Eternal::new);
    public static final RegistryObject<DragonEnchantment> FROST_HEART = ENCHANTMENTS.register("frost_heart", FrostHeart::new);
    public static final RegistryObject<DragonEnchantment> HOMING = ENCHANTMENTS.register("homing", Homing::new);
    public static final RegistryObject<DragonEnchantment> OBLITERATE = ENCHANTMENTS.register("obliterate", Obliterate::new);
    public static final RegistryObject<DragonEnchantment> TRUE_EDGE = ENCHANTMENTS.register("true_edge", TrueEdge::new);
    public static final RegistryObject<DragonEnchantment> VENOMOUS = ENCHANTMENTS.register("venomous", Venomous::new);
    public static final RegistryObject<DragonEnchantment> WATER_ASPECT = ENCHANTMENTS.register("water_aspect", WaterAspect::new);
    public static final RegistryObject<DragonEnchantment> WIND_STEP = ENCHANTMENTS.register("wind_step", WindStep::new);

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EnchantmentEvents {
        @SubscribeEvent
        public static void endermanEvent(EntityTeleportEvent event) {
            LivingEntity target;
            Level level;
            List entities;
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity && !(entities = (level = (target = (LivingEntity)entity).m_9236_()).m_45976_(LivingEntity.class, target.m_20191_().m_82400_(100.0))).isEmpty()) {
                for (LivingEntity entity2 : entities) {
                    if (entity2 == target || !DamageHelper.canCollideWith((Entity)target, (Entity)entity2)) continue;
                    int enchLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ENDERFERENCE.get()), (LivingEntity)entity2);
                    if (enchLevel > 0 && entity2.m_142582_((Entity)target)) {
                        event.setCanceled(true);
                    }
                    if (enchLevel <= 1 || !(entity2.m_20270_((Entity)target) <= 20.0f)) continue;
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void attackEvent(LivingAttackEvent event) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                DragonEnchantment trueEdge = (DragonEnchantment)((Object)TRUE_EDGE.get());
                int level = EnchantmentHelper.m_44836_((Enchantment)trueEdge, (LivingEntity)attacker);
                TrueEdge.handleDamage(event.getSource(), level);
                LivingEntity hurt = event.getEntity();
                DragonEnchantment endWalker = (DragonEnchantment)((Object)END_WALKER.get());
                level = EnchantmentHelper.m_44836_((Enchantment)endWalker, (LivingEntity)hurt);
                EndWalker.handleTp(event.getSource(), level, hurt, event);
            }
        }

        @SubscribeEvent
        public static void hurtEvent(LivingHurtEvent event) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                DragonEnchantment berserk = (DragonEnchantment)((Object)BERSERK.get());
                int level = EnchantmentHelper.m_44836_((Enchantment)berserk, (LivingEntity)attacker);
                event.setAmount(event.getAmount() * (float)Berserk.getDamageModifier(attacker, level));
            }
        }

        @SubscribeEvent
        public static void deathEvent(LivingDeathEvent event) {
            if (event.getEntity() != null) {
                LivingEntity hurt = event.getEntity();
                Entity entity = event.getSource().m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    DragonEnchantment devour = (DragonEnchantment)((Object)DEVOUR.get());
                    int level = EnchantmentHelper.m_44836_((Enchantment)devour, (LivingEntity)attacker);
                    Devour.handleDeath(devour, level, attacker, hurt);
                    DragonEnchantment obliterate = (DragonEnchantment)((Object)OBLITERATE.get());
                    level = EnchantmentHelper.m_44836_((Enchantment)obliterate, (LivingEntity)attacker);
                    Obliterate.handleDeath(level, attacker, hurt);
                }
                DragonEnchantment eternal = (DragonEnchantment)((Object)ETERNAL.get());
                int level = EnchantmentHelper.m_44836_((Enchantment)eternal, (LivingEntity)hurt);
                Eternal.handleDeath(eternal, event, level, hurt);
            }
        }

        @SubscribeEvent
        public static void criticalEvent(CriticalHitEvent event) {
            if (event.getEntity() != null) {
                Player player = event.getEntity();
                int level = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)CRITICAL_SUNDER.get()), (LivingEntity)player);
                if (level > 0) {
                    event.setDamageModifier(event.getDamageModifier() + 0.2f * (float)level);
                }
            }
        }

        @SubscribeEvent
        public static void arrowNockEvent(ArrowNockEvent event) {
        }

        @SubscribeEvent
        public static void arrowEvent(ArrowLooseEvent event) {
        }

        @SubscribeEvent
        public static void tickEvent(LivingEvent.LivingTickEvent event) {
            LivingEntity user = event.getEntity();
            DragonEnchantment endStep = (DragonEnchantment)((Object)END_STEP.get());
            int level = EnchantmentHelper.m_44836_((Enchantment)endStep, (LivingEntity)user);
            EndStep.handleBowTick(level, user);
            DragonEnchantment detonate = (DragonEnchantment)((Object)DETONATE.get());
            level = EnchantmentHelper.m_44836_((Enchantment)detonate, (LivingEntity)user);
            Detonate.handleBowTick(level, user);
            DragonEnchantment homing = (DragonEnchantment)((Object)HOMING.get());
            level = EnchantmentHelper.m_44836_((Enchantment)homing, (LivingEntity)user);
            Homing.handleBowTick(level, user);
            DragonEnchantment windStep = (DragonEnchantment)((Object)WIND_STEP.get());
            level = EnchantmentHelper.m_44836_((Enchantment)windStep, (LivingEntity)user);
            WindStep.handleSprint(level, user);
        }
    }
}

