/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnItemAttributeTooltip;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.items.ScrollItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SonicBoomScroll
extends ScrollItem {
    private static int ATTACK_DAMAGE = 14;
    private static Range<Integer> ATTACK_RANGE = Range.of((Number)12, (Number)30);

    @Override
    protected void useScroll(ItemStack itemStack, Level level, LivingEntity entity, float useRatio) {
        super.useScroll(itemStack, level, entity, useRatio);
        if (!Side.isLogicalServer()) {
            return;
        }
        AnyPos direction = EntityHelper.getLookDirection((Entity)entity);
        int attackRange = (int)ATTACK_RANGE.lerp(useRatio);
        for (int idx = 0; idx < attackRange; ++idx) {
            Vec3 position = direction.mul((Number)idx).add(entity.m_20299_(0.75f)).vec3();
            ParticleEmitter.of((ParticleOptions)ParticleTypes.f_235902_).position(position).emit(level);
            level.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)position, (double)4.0, (double)4.0, (double)4.0), target -> !target.equals((Object)entity)).forEach(target -> {
                Vec3 knockbackDirection = direction.mul((Number)-1.0, (Number)0.0, (Number)-1.0).vec3();
                target.m_6469_(DamageSource.m_216876_((Entity)entity), (float)ATTACK_DAMAGE);
                target.m_147240_(1.0, knockbackDirection.f_82479_, knockbackDirection.f_82481_);
            });
        }
    }

    @Override
    protected SoundEvent getPrepareSound() {
        return SoundEvents.f_215772_;
    }

    @Override
    protected SoundEvent getCastSound() {
        return SoundEvents.f_215771_;
    }

    private static void addSpellInfo(OnItemAttributeTooltip data) {
        List.of(TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_damage", (Object[])new Object[]{ATTACK_DAMAGE}).m_130940_(ChatFormatting.DARK_GREEN), TextHelper.translatable((String)"majruszsdifficulty.scrolls.attack_range", (Object[])new Object[]{"%d-%d".formatted(SonicBoomScroll.ATTACK_RANGE.from, SonicBoomScroll.ATTACK_RANGE.to)}).m_130940_(ChatFormatting.DARK_GREEN)).forEach(component -> data.add(EquipmentSlot.MAINHAND, (Component)component));
    }

    static {
        OnItemAttributeTooltip.listen(SonicBoomScroll::addSpellInfo).addCondition(data -> data.itemStack.m_41720_() instanceof SonicBoomScroll);
        Serializables.getStatic(Config.Items.class).define("sonic_boom_scroll", SonicBoomScroll.class);
        Serializables.getStatic(SonicBoomScroll.class).define("attack_damage", Reader.integer(), () -> ATTACK_DAMAGE, v -> {
            ATTACK_DAMAGE = (Integer)Range.of((Number)1, (Number)100).clamp((Number)v);
        }).define("attack_range", Reader.range((IReader)Reader.integer()), () -> ATTACK_RANGE, v -> {
            ATTACK_RANGE = Range.of((Number)1, (Number)100).clamp(v);
        });
    }
}

