/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.command.Command;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Side;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmyHelper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MobGroups {
    private static Map<String, GroupDef> GROUPS = Map.of("skeletons", new GroupDef("normal", 0.1f, true, List.of(new LeaderDef(EntityType.f_20524_, MajruszsDifficulty.HELPER.getLocation("mob_groups/skeleton_leader"))), (Range<Integer>)Range.of((Number)1, (Number)3), List.of(new SidekickDef(EntityType.f_20524_, MajruszsDifficulty.HELPER.getLocation("mob_groups/skeleton_sidekick")))), "undead", new GroupDef("normal", 0.1f, true, List.of(new LeaderDef(EntityType.f_20524_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_skeleton")), new LeaderDef(EntityType.f_20481_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_skeleton")), new LeaderDef(EntityType.f_20501_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_mob")), new LeaderDef(EntityType.f_20458_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_3_mob"))), (Range<Integer>)Range.of((Number)2, (Number)4), List.of(new SidekickDef(EntityType.f_20524_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")), new SidekickDef(EntityType.f_20481_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")), new SidekickDef(EntityType.f_20501_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")), new SidekickDef(EntityType.f_20458_, MajruszsDifficulty.HELPER.getLocation("undead_army/wave_2_mob")))), "zombie_miners", new GroupDef("expert", 0.25f, true, List.of(new LeaderDef(EntityType.f_20501_, MajruszsDifficulty.HELPER.getLocation("mob_groups/zombie_leader"))), (Range<Integer>)Range.of((Number)1, (Number)3), List.of(new SidekickDef(EntityType.f_20501_, MajruszsDifficulty.HELPER.getLocation("mob_groups/zombie_sidekick")))), "piglins", new GroupDef("expert", 0.25f, true, List.of(new LeaderDef(EntityType.f_20511_, MajruszsDifficulty.HELPER.getLocation("mob_groups/piglin_leader"))), (Range<Integer>)Range.of((Number)1, (Number)3), List.of(new SidekickDef(EntityType.f_20511_, MajruszsDifficulty.HELPER.getLocation("mob_groups/piglin_sidekick")))));
    private static final IParameter<String> NAME = Command.string().named("name").suggests(() -> GROUPS.keySet().stream().toList());

    private static void tryToSpawnGroup(OnEntitySpawned data) {
        PathfinderMob leader = (PathfinderMob)data.entity;
        GameStage gameStage = GameStageHelper.determineGameStage(data);
        for (Map.Entry<String, GroupDef> entry : GROUPS.entrySet()) {
            LeaderDef leaderDef;
            String id = entry.getKey();
            if (id.equals("zombie_miners") && data.entity.m_20182_().f_82480_ > 50.0) continue;
            GroupDef groupDef = entry.getValue();
            if (groupDef.requiredGameStage.getOrdinal() > gameStage.getOrdinal() || (leaderDef = (LeaderDef)Random.next(groupDef.leaders.stream().filter(def -> def.type.equals((Object)leader.m_6095_())).toList())) == null) continue;
            double chance = (double)groupDef.chance * (groupDef.isScaledByCRD ? LevelHelper.getClampedRegionalDifficultyAt((Level)data.getLevel(), (BlockPos)leader.m_20183_()) : 1.0);
            if (!Random.check((double)chance)) continue;
            MobGroups.markAsGroupPart(data.entity);
            MobGroups.spawn((PathfinderMob)data.entity, groupDef);
            MobGroups.giveItems(leader, leaderDef.equipment);
            break;
        }
    }

    private static void spawn(PathfinderMob leader, GroupDef groupDef) {
        Level level = leader.m_9236_();
        int count = Random.nextInt(groupDef.count);
        for (int idx = 0; idx < count; ++idx) {
            SidekickDef sidekickDef = (SidekickDef)Random.next(groupDef.sidekicks);
            Entity entity = EntityHelper.createSpawner(() -> sidekickDef.type, (Level)level).position(MobGroups.getRandomizedPosition(level, leader.m_20182_())).mobSpawnType(MobSpawnType.EVENT).beforeEvent(MobGroups::markAsGroupPart).spawn();
            if (!(entity instanceof PathfinderMob)) continue;
            PathfinderMob sidekick = (PathfinderMob)entity;
            MobGroups.addSidekickGoals(sidekick, leader);
            MobGroups.giveItems(sidekick, sidekickDef.equipment);
        }
    }

    private static void giveItems(PathfinderMob mob, ResourceLocation id) {
        LootHelper.getLootTable((ResourceLocation)id).m_230922_(LootHelper.toGiftParams((Entity)mob)).forEach(itemStack -> ItemHelper.equip((Mob)mob, (ItemStack)itemStack));
        Arrays.stream(EquipmentSlot.values()).forEach(slot -> mob.m_21409_(slot, 0.05f));
    }

    private static void addSidekickGoals(PathfinderMob sidekick, PathfinderMob leader) {
        EntityHelper.getGoalSelector((Mob)sidekick).m_25352_(1, (Goal)new FollowGroupLeaderGoal((Mob)sidekick, (Mob)leader, 1.0, 6.0f, 5.0f));
        EntityHelper.getTargetSelector((Mob)sidekick).m_25352_(1, (Goal)new TargetAsLeaderGoal(sidekick, leader));
    }

    private static Vec3 getRandomizedPosition(Level level, Vec3 position) {
        for (int idx = 0; idx < 3; ++idx) {
            Vec3 newPosition = AnyPos.from((Vec3)position).add((Number)Random.nextInt((int)-3, (int)4), (Number)0.0, (Number)Random.nextInt((int)-3, (int)4)).vec3();
            Optional spawnPoint = LevelHelper.findBlockPosOnGround((Level)level, (Number)newPosition.f_82479_, (Range)Range.of((Number)(newPosition.f_82480_ - 3.0), (Number)(newPosition.f_82480_ + 3.0)), (Number)newPosition.f_82481_);
            if (!spawnPoint.isPresent()) continue;
            return AnyPos.from((BlockPos)((BlockPos)spawnPoint.get())).add((Number)0.5, (Number)0.0, (Number)0.5).vec3();
        }
        return position;
    }

    private static void markAsGroupPart(Entity entity) {
        Serializables.modify((Object)new Tag(), (net.minecraft.nbt.Tag)EntityHelper.getOrCreateExtraTag((Entity)entity), tag -> {
            tag.belongsToMobGroup = true;
        });
    }

    private static boolean belongsToMobGroup(Entity entity) {
        CompoundTag tag = EntityHelper.getExtraTag((Entity)entity);
        return tag != null && ((Tag)Serializables.read((Object)new Tag(), (net.minecraft.nbt.Tag)tag)).belongsToMobGroup;
    }

    private static int spawn(CommandData data) throws CommandSyntaxException {
        Entity entity = data.getCaller();
        if (!(entity instanceof Player)) {
            return -1;
        }
        Player player = (Player)entity;
        String name = (String)data.get(NAME);
        GroupDef groupDef = GROUPS.get(name);
        if (groupDef == null) {
            return -1;
        }
        LeaderDef leaderDef = (LeaderDef)Random.next(groupDef.leaders);
        Entity entity2 = EntityHelper.createSpawner(() -> leaderDef.type, (Level)player.m_9236_()).position(player.m_20182_()).mobSpawnType(MobSpawnType.COMMAND).spawn();
        if (!(entity2 instanceof PathfinderMob)) {
            return -1;
        }
        PathfinderMob leader = (PathfinderMob)entity2;
        MobGroups.spawn(leader, groupDef);
        MobGroups.giveItems(leader, leaderDef.equipment);
        return 0;
    }

    static {
        OnEntitySpawned.listen(MobGroups::tryToSpawnGroup).addCondition(Condition.isLogicalServer()).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity instanceof PathfinderMob).addCondition(data -> !MobGroups.belongsToMobGroup(data.entity)).addCondition(data -> !data.getLevel().equals(Side.getServer().m_129783_()) || !UndeadArmyHelper.isPartOfUndeadArmy(data.entity));
        Command.create().literal(new String[]{"summongroup"}).hasPermission(4).parameter(NAME).execute(MobGroups::spawn).register();
        Serializables.getStatic(Config.Features.class).define("mob_groups", Reader.map((IReader)Reader.custom(GroupDef::new)), () -> GROUPS, v -> {
            GROUPS = v;
        });
        Serializables.get(GroupDef.class).define("required_game_stage", Reader.string(), s -> s.requiredGameStage.getId(), (s, v) -> {
            s.requiredGameStage = GameStageHelper.find(v);
        }).define("chance", Reader.number(), s -> Float.valueOf(s.chance), (s, v) -> {
            s.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), s -> s.isScaledByCRD, (s, v) -> {
            s.isScaledByCRD = v;
        }).define("leader_types", Reader.list((IReader)Reader.custom(LeaderDef::new)), s -> s.leaders, (s, v) -> {
            s.leaders = v;
        }).define("sidekicks_count", Reader.range((IReader)Reader.integer()), s -> s.count, (s, v) -> {
            s.count = Range.of((Number)1, (Number)10).clamp(v);
        }).define("sidekick_types", Reader.list((IReader)Reader.custom(SidekickDef::new)), s -> s.sidekicks, (s, v) -> {
            s.sidekicks = v;
        });
        Serializables.get(LeaderDef.class).define("type", Reader.entityType(), s -> s.type, (s, v) -> {
            s.type = v;
        }).define("equipment", Reader.location(), s -> s.equipment, (s, v) -> {
            s.equipment = v;
        });
        Serializables.get(SidekickDef.class).define("type", Reader.entityType(), s -> s.type, (s, v) -> {
            s.type = v;
        }).define("equipment", Reader.location(), s -> s.equipment, (s, v) -> {
            s.equipment = v;
        });
    }

    public static class GroupDef {
        public GameStage requiredGameStage = GameStageHelper.find("normal");
        public float chance = 0.0f;
        public boolean isScaledByCRD = false;
        public List<LeaderDef> leaders = List.of();
        public Range<Integer> count = Range.of((Number)1, (Number)10);
        public List<SidekickDef> sidekicks = List.of();

        public GroupDef(String gameStageId, float chance, boolean isScaledByCRD, List<LeaderDef> leaders, Range<Integer> count, List<SidekickDef> sidekicks) {
            this.requiredGameStage = GameStageHelper.find(gameStageId);
            this.chance = chance;
            this.isScaledByCRD = isScaledByCRD;
            this.leaders = leaders;
            this.count = count;
            this.sidekicks = sidekicks;
        }

        public GroupDef() {
        }
    }

    public static class LeaderDef {
        public EntityType<?> type;
        public ResourceLocation equipment;

        public LeaderDef(EntityType<?> type, ResourceLocation equipment) {
            this.type = type;
            this.equipment = equipment;
        }

        public LeaderDef() {
        }
    }

    public static class SidekickDef {
        public EntityType<?> type;
        public ResourceLocation equipment;

        public SidekickDef(EntityType<?> type, ResourceLocation equipment) {
            this.type = type;
            this.equipment = equipment;
        }

        public SidekickDef() {
        }
    }

    public static class FollowGroupLeaderGoal
    extends Goal {
        private final Mob sidekick;
        private final Mob leader;
        private final double speedModifier;
        private final float maxDistanceFromLeader;
        private final float stopDistance;
        private final PathNavigation navigation;
        private int ticksToRecalculatePath;

        public FollowGroupLeaderGoal(Mob sidekick, Mob leader, double speedModifier, float maxDistanceFromLeader, float stopDistance) {
            this.sidekick = sidekick;
            this.leader = leader;
            this.navigation = sidekick.m_21573_();
            this.speedModifier = speedModifier;
            this.maxDistanceFromLeader = maxDistanceFromLeader;
            this.stopDistance = stopDistance;
            this.ticksToRecalculatePath = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return this.leader != null && this.leader.m_6084_() && this.leader.m_20270_((Entity)this.sidekick) >= this.maxDistanceFromLeader && this.sidekick.m_5448_() == null;
        }

        public void m_8037_() {
            if (this.leader == null || --this.ticksToRecalculatePath > 0) {
                return;
            }
            this.sidekick.m_21563_().m_24960_((Entity)this.leader, 10.0f, (float)this.sidekick.m_21529_());
            this.ticksToRecalculatePath = 20;
            this.navigation.m_5624_((Entity)this.leader, this.speedModifier);
        }

        public boolean m_8045_() {
            return this.leader != null && !this.navigation.m_26571_() && this.sidekick.m_20270_((Entity)this.leader) > this.stopDistance;
        }

        public void m_8056_() {
            this.ticksToRecalculatePath = 0;
        }
    }

    public static class TargetAsLeaderGoal
    extends TargetGoal {
        private static final TargetingConditions CONDITIONS = TargetingConditions.m_148352_().m_148355_().m_26893_();
        private final PathfinderMob leader;

        public TargetAsLeaderGoal(PathfinderMob sidekick, PathfinderMob leader) {
            super((Mob)sidekick, false);
            this.leader = leader;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            return this.leader != null && this.leader.m_6084_() && this.m_26150_(this.leader.m_5448_(), CONDITIONS) && this.leader.m_5448_() != this.f_26135_.m_5448_();
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.leader.m_5448_());
            this.f_26137_ = this.leader.m_5448_();
            this.f_26138_ = 300;
            super.m_8056_();
        }
    }

    private static class Tag {
        public boolean belongsToMobGroup = false;

        private Tag() {
        }

        static {
            Serializables.get(Tag.class).define("belongs_to_mob_group", Reader.bool(), s -> s.belongsToMobGroup, (s, v) -> {
                s.belongsToMobGroup = v;
            });
        }
    }
}

