/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.events.base.CustomCondition;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.mixin.IMixinCreeper;
import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CreeperExplodeBehindWall {
    private static boolean IS_ENABLED = true;
    private static GameStage REQUIRED_GAME_STAGE = GameStageHelper.find("expert");
    private static float CHANCE = 1.0f;
    private static boolean IS_SCALED_BY_CRD = false;

    private static void modifyAI(OnEntitySpawned data) {
        Creeper creeper = (Creeper)data.entity;
        EntityHelper.getGoalSelector((Mob)creeper).m_25352_(1, (Goal)new ExplodeBehindWallGoal(creeper));
    }

    static {
        OnEntitySpawned.listen(CreeperExplodeBehindWall::modifyAI).addCondition(Condition.isLogicalServer()).addCondition(Condition.chanceCRD(() -> Float.valueOf(CHANCE), () -> IS_SCALED_BY_CRD)).addCondition(data -> IS_ENABLED).addCondition(CustomCondition.check(REQUIRED_GAME_STAGE)).addCondition(data -> data.entity instanceof Creeper);
        Serializables.getStatic(Config.Features.class).define("creeper_explode_behind_wall", CreeperExplodeBehindWall.class);
        Serializables.getStatic(CreeperExplodeBehindWall.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("required_game_stage", Reader.string(), () -> REQUIRED_GAME_STAGE.getId(), v -> {
            REQUIRED_GAME_STAGE = GameStageHelper.find(v);
        }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
            CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), () -> IS_SCALED_BY_CRD, v -> {
            IS_SCALED_BY_CRD = v;
        });
    }

    public static class ExplodeBehindWallGoal
    extends Goal {
        private static final double MAXIMUM_START_DISTANCE = 19.0;
        private static final double MAXIMUM_EXPLODE_DISTANCE = 49.0;
        private static final double OFFSET = 16.0;
        private final Creeper creeper;
        private LivingEntity attackTarget;

        public ExplodeBehindWallGoal(Creeper creeper) {
            this.creeper = creeper;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Player target = this.getNearestPlayer(this.creeper);
            return this.creeper.m_32310_() > 0 || target != null && this.creeper.m_20280_((Entity)target) < 19.0 * this.getDistanceMultiplier();
        }

        public void m_8056_() {
            this.creeper.m_21573_().m_26573_();
            this.attackTarget = this.getNearestPlayer(this.creeper);
        }

        public void m_8041_() {
            this.attackTarget = null;
        }

        public void m_8037_() {
            if (this.attackTarget == null || this.creeper.m_20280_((Entity)this.attackTarget) > 49.0 * this.getDistanceMultiplier()) {
                this.creeper.m_32283_(-1);
            } else {
                this.creeper.m_32283_(1);
            }
        }

        private double getDistanceMultiplier() {
            double sizeMultiplier = (float)((IMixinCreeper)this.creeper).getExplosionRadius() / 3.0f;
            double chargedMultiplier = this.creeper.m_7090_() ? 2.0 : 1.0;
            return sizeMultiplier * chargedMultiplier;
        }

        @Nullable
        private Player getNearestPlayer(Creeper creeper) {
            Level level = creeper.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel level2 = (ServerLevel)level;
            Player nearestPlayer = null;
            for (Player player : EntityHelper.getEntitiesNearby(Player.class, (ServerLevel)level2, (Vec3)creeper.m_20182_(), (double)16.0)) {
                if (EntityHelper.isOnCreativeMode((Player)player) || EntityHelper.isOnSpectatorMode((Player)player) || nearestPlayer != null && !(creeper.m_20280_((Entity)player) < creeper.m_20280_((Entity)nearestPlayer))) continue;
                nearestPlayer = player;
            }
            return nearestPlayer;
        }
    }
}

