/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.entity.EffectHelper;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.bleeding.BleedingGui;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BleedingParticles {
    private static void emit(OnEntityTicked data) {
        int amplifier = EffectHelper.getAmplifier(MajruszsDifficulty.BLEEDING_EFFECT, (LivingEntity)data.entity).orElse(0);
        float walkDistanceDelta = EntityHelper.getWalkDistanceDelta((LivingEntity)data.entity);
        ParticleEmitter.of(MajruszsDifficulty.BLOOD_PARTICLE).count(Random.round((double)(0.5 + 0.5 * (15.0 + (double)amplifier) * (double)walkDistanceDelta))).sizeBased((Entity)data.entity).offset(AnyPos.from((Number)Float.valueOf(data.entity.m_20205_()), (Number)Float.valueOf(data.entity.m_20206_()), (Number)Float.valueOf(data.entity.m_20205_())).mul((Number)0.25, (Number)0.25, (Number)0.25).vec3()).emit((Level)data.getServerLevel());
    }

    private static void emit(OnEntityDied data) {
        ParticleEmitter.of(MajruszsDifficulty.BLOOD_PARTICLE).count(50).sizeBased((Entity)data.target).offset(AnyPos.from((Number)Float.valueOf(data.target.m_20205_()), (Number)Float.valueOf(data.target.m_20206_()), (Number)Float.valueOf(data.target.m_20205_())).mul((Number)0.25, (Number)0.25, (Number)0.25).vec3()).emit((Level)data.getServerLevel());
    }

    private static void addGuiOverlay(OnEntityPreDamaged data) {
        MajruszsDifficulty.BLEEDING_GUI.sendToClient((ServerPlayer)data.target, (Object)new Message(3));
    }

    static {
        OnEntityTicked.listen(BleedingParticles::emit).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.15f)).addCondition(data -> EffectHelper.has(MajruszsDifficulty.BLEEDING_EFFECT, (LivingEntity)data.entity));
        OnEntityDied.listen(BleedingParticles::emit).addCondition(Condition.isLogicalServer()).addCondition(data -> EffectHelper.has(MajruszsDifficulty.BLEEDING_EFFECT, (LivingEntity)data.target));
        OnEntityPreDamaged.listen(BleedingParticles::addGuiOverlay).priority(Priority.LOWEST).addCondition(data -> data.source == MajruszsDifficulty.BLEEDING_DAMAGE_SOURCE).addCondition(data -> data.target instanceof ServerPlayer);
    }

    public static class Message {
        int count;

        public Message(int count) {
            this.count = count;
        }

        public Message() {
        }

        static {
            Serializables.get(Message.class).define("count", Reader.integer(), s -> s.count, (s, v) -> {
                s.count = v;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        private static void onMessageReceived(Message message) {
            BleedingGui.addBloodOnScreen(message.count);
        }

        static {
            MajruszsDifficulty.BLEEDING_GUI.addClientCallback(Client::onMessageReceived);
        }
    }
}

