/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.entity.EffectHelper;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.type.ICancellableEvent;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.Bleeding;
import com.majruszsdifficulty.events.OnBleedingCheck;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BleedingDamage {
    static final int DAMAGE_COOLDOWN = TimeHelper.toTicks((double)4.0);
    static final Map<Integer, Integer> ENTITY_TICKS = new HashMap<Integer, Integer>();

    private static void tryToApply(OnEntityDamaged data) {
        if (((OnBleedingCheck)Events.dispatch((ICancellableEvent)new OnBleedingCheck(data))).isBleedingTriggered() && Bleeding.apply(data.target, data.attacker)) {
            BleedingDamage.dealDamage(data.target);
            BleedingDamage.giveAdvancements(data);
        }
    }

    private static void tick(OnEntityTicked data) {
        int amplifier = EffectHelper.getAmplifier(MajruszsDifficulty.BLEEDING_EFFECT, (LivingEntity)data.entity).orElse(0);
        int extraDuration = Random.round((double)(0.3 * (double)(amplifier + 2) * (7.26 * (double)EntityHelper.getWalkDistanceDelta((LivingEntity)data.entity) + 1.0)));
        int duration = ENTITY_TICKS.getOrDefault(data.entity.m_19879_(), 0) + extraDuration;
        if (duration > DAMAGE_COOLDOWN) {
            BleedingDamage.dealDamage(data.entity);
            duration = 0;
        }
        ENTITY_TICKS.put(data.entity.m_19879_(), duration);
    }

    private static void dealDamage(LivingEntity entity) {
        MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)MajruszsDifficulty.BLEEDING_EFFECT.get());
        if (mobEffectInstance instanceof Bleeding.MobEffectInstance) {
            Bleeding.MobEffectInstance effectInstance = (Bleeding.MobEffectInstance)mobEffectInstance;
            Vec3 motion = entity.m_20184_();
            entity.m_6469_((DamageSource)new CustomSource(effectInstance.damageSourceEntity), 1.0f);
            entity.m_20256_(motion);
        } else {
            entity.m_6469_(MajruszsDifficulty.BLEEDING_DAMAGE_SOURCE, 1.0f);
        }
    }

    private static void giveAdvancements(OnEntityDamaged data) {
        ServerPlayer player;
        LivingEntity livingEntity = data.target;
        if (livingEntity instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            MajruszsDifficulty.HELPER.triggerAchievement(player, "bleeding_received");
            if (data.source == DamageSource.f_19314_) {
                MajruszsDifficulty.HELPER.triggerAchievement(player, "cactus_bleeding");
            }
        }
        if ((livingEntity = data.attacker) instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            MajruszsDifficulty.HELPER.triggerAchievement(player, "bleeding_inflicted");
        }
    }

    static {
        OnEntityDamaged.listen(BleedingDamage::tryToApply).addCondition(Condition.isLogicalServer()).addCondition(Bleeding::isEnabled).addCondition(data -> Bleeding.canApplyTo(data.target));
        OnEntityTicked.listen(BleedingDamage::tick).addCondition(Condition.isLogicalServer()).addCondition(data -> EffectHelper.has(MajruszsDifficulty.BLEEDING_EFFECT, (LivingEntity)data.entity));
    }

    public static class CustomSource
    extends DamageSource {
        @Nullable
        protected final Entity damageSourceEntity;

        public CustomSource(@Nullable Entity damageSourceEntity) {
            super("bleeding");
            this.damageSourceEntity = damageSourceEntity;
            this.m_19380_();
        }

        public CustomSource() {
            this(null);
        }

        @Nullable
        public Entity m_7640_() {
            return this.damageSourceEntity != null ? null : super.m_7640_();
        }

        @Nullable
        public Entity m_7639_() {
            return this.damageSourceEntity != null ? this.damageSourceEntity : super.m_7639_();
        }
    }
}

