/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.memoryleakfix.mixinextras.sugar.impl;

import ca.fxco.memoryleakfix.mixinextras.injector.LateApplyingInjectorInfo;
import ca.fxco.memoryleakfix.mixinextras.sugar.SugarBridge;
import ca.fxco.memoryleakfix.mixinextras.sugar.impl.SingleIterationList;
import ca.fxco.memoryleakfix.mixinextras.sugar.impl.SugarApplicationException;
import ca.fxco.memoryleakfix.mixinextras.sugar.impl.SugarInjector;
import ca.fxco.memoryleakfix.mixinextras.sugar.impl.SugarWrapper;
import ca.fxco.memoryleakfix.mixinextras.sugar.impl.handlers.HandlerInfo;
import ca.fxco.memoryleakfix.mixinextras.utils.CompatibilityHelper;
import ca.fxco.memoryleakfix.mixinextras.utils.GenericParamParser;
import ca.fxco.memoryleakfix.mixinextras.utils.MixinInternals;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.asm.MethodNodeEx;

@InjectionInfo.AnnotationType(value=SugarWrapper.class)
@InjectionInfo.HandlerPrefix(value="sugarWrapper")
public class SugarWrapperInjectionInfo
extends InjectionInfo
implements LateApplyingInjectorInfo {
    private final AnnotationNode originalAnnotation;
    private final ArrayList<Type> generics;
    private final MethodNode handler;
    private final InjectionInfo delegate;
    private final SugarInjector sugarInjector;
    private final boolean lateApply;

    public SugarWrapperInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation);
        method.visibleAnnotations.remove(annotation);
        this.originalAnnotation = (AnnotationNode)Annotations.getValue((AnnotationNode)annotation, (String)"original");
        method.visibleAnnotations.add(this.originalAnnotation);
        this.generics = new ArrayList<Type>(GenericParamParser.getParameterGenerics(method.desc, (String)Annotations.getValue((AnnotationNode)annotation, (String)"signature")));
        this.handler = this.prepareHandler(method);
        this.sugarInjector = new SugarInjector(this, mixin.getMixin(), this.handler, this.generics);
        this.sugarInjector.stripSugar();
        this.delegate = InjectionInfo.parse((MixinTargetContext)mixin, (MethodNode)this.handler);
        this.sugarInjector.setTargets(MixinInternals.getTargets(this.delegate));
        this.lateApply = this.delegate instanceof LateApplyingInjectorInfo;
        if (this.lateApply) {
            ((LateApplyingInjectorInfo)this.delegate).wrap(this);
        } else {
            this.checkDelegate();
        }
    }

    protected void readAnnotation() {
    }

    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return null;
    }

    public boolean isValid() {
        return this.delegate.isValid();
    }

    public void prepare() {
        this.delegate.prepare();
        this.handler.visibleAnnotations.remove(InjectionInfo.getInjectorAnnotation((IMixinInfo)CompatibilityHelper.getMixin(this).getMixin(), (MethodNode)this.handler));
        this.sugarInjector.prepareSugar();
    }

    public void preInject() {
        CompatibilityHelper.preInject(this.delegate);
    }

    public void inject() {
        if (this.lateApply) {
            this.delegate.inject();
        } else {
            this.doInject();
        }
    }

    private void doInject() {
        Map<Target, List<InjectionNodes.InjectionNode>> targets = MixinInternals.getTargets(this.delegate);
        Injector injector = MixinInternals.getInjector(this.delegate);
        HashMap<Target, List<Pair<InjectionNodes.InjectionNode, MethodInsnNode>>> handlerCallMap = new HashMap<Target, List<Pair<InjectionNodes.InjectionNode, MethodInsnNode>>>();
        for (Map.Entry<Target, List<InjectionNodes.InjectionNode>> entry : targets.entrySet()) {
            Target target = entry.getKey();
            ArrayList<Pair> handlerCalls = new ArrayList<Pair>();
            handlerCallMap.put(target, handlerCalls);
            HashSet<MethodInsnNode> discoveredHandlerCalls = new HashSet<MethodInsnNode>(this.findHandlerCalls(target));
            for (InjectionNodes.InjectionNode node : entry.getValue()) {
                SugarWrapperInjectionInfo.inject(injector, target, node);
                for (MethodInsnNode handlerCall : this.findHandlerCalls(target)) {
                    if (!discoveredHandlerCalls.add(handlerCall)) continue;
                    handlerCalls.add(Pair.of((Object)node, (Object)handlerCall));
                }
            }
            SugarWrapperInjectionInfo.postInject(injector, target, entry.getValue());
        }
        targets.clear();
        this.sugarInjector.reSugarHandler();
        this.sugarInjector.transformHandlerCalls(handlerCallMap);
    }

    public void postInject() {
        if (!this.lateApply) {
            this.doPostInject(() -> ((InjectionInfo)this.delegate).postInject());
        }
    }

    private void doPostInject(Runnable postInject) {
        try {
            postInject.run();
        }
        catch (InjectionError | InvalidInjectionException e) {
            for (SugarApplicationException sugarException : this.sugarInjector.getExceptions()) {
                e.addSuppressed((Throwable)((Object)sugarException));
            }
            throw e;
        }
    }

    public void addCallbackInvocation(MethodNode handler) {
        this.delegate.addCallbackInvocation(handler);
    }

    @Override
    public void lateInject() {
        this.doInject();
    }

    @Override
    public void latePostInject() {
        this.doPostInject(((LateApplyingInjectorInfo)this.delegate)::latePostInject);
    }

    @Override
    public void wrap(LateApplyingInjectorInfo outer) {
        throw new UnsupportedOperationException("Cannot wrap a sugar wrapper!");
    }

    private MethodNode prepareHandler(MethodNode original) {
        IMixinInfo mixin = CompatibilityHelper.getMixin(this).getMixin();
        HandlerInfo handlerInfo = SugarInjector.getHandlerInfo(mixin, original, this.generics);
        if (handlerInfo == null) {
            return original;
        }
        MethodNodeEx newMethod = new MethodNodeEx(original.access, MethodNodeEx.getName((MethodNode)original), original.desc, original.signature, original.exceptions.toArray(new String[0]), mixin);
        original.accept((MethodVisitor)newMethod);
        original.visibleAnnotations.remove(this.originalAnnotation);
        newMethod.name = original.name;
        newMethod.visitAnnotation(Type.getDescriptor(SugarBridge.class), false);
        handlerInfo.transformHandler(this.classNode, (MethodNode)newMethod);
        handlerInfo.transformGenerics(this.generics);
        this.classNode.methods.add(newMethod);
        return newMethod;
    }

    private void checkDelegate() {
        try {
            if (this.delegate.getClass().getMethod("inject", new Class[0]).getDeclaringClass() != InjectionInfo.class) {
                throw new UnsupportedOperationException(this.delegate.getClass() + "overrides 'inject' and so is not automatically compatible with Sugar.Please report to LlamaLad7 in case manual compatibility can be added.");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private List<MethodInsnNode> findHandlerCalls(Target target) {
        ArrayList<MethodInsnNode> result = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insn : target) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode call = (MethodInsnNode)insn;
            if (!call.owner.equals(this.classNode.name) || !call.name.equals(this.handler.name) || !call.desc.equals(this.handler.desc)) continue;
            result.add(call);
        }
        return result;
    }

    private static void inject(Injector injector, Target target, InjectionNodes.InjectionNode node) {
        injector.inject(target, new SingleIterationList<InjectionNodes.InjectionNode>(Collections.singletonList(node), 0));
    }

    private static void postInject(Injector injector, Target target, List<InjectionNodes.InjectionNode> nodes) {
        injector.inject(target, new SingleIterationList<InjectionNodes.InjectionNode>(nodes, 1));
    }
}

