/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import java.util.Stack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface Shieldable
extends Ability {
    public ShieldPosition getShieldPosition(int var1);

    public byte getMaxShieldsPerSide();

    default public void tickShieldShip() {
    }

    default public void defineShieldShipSynchedData() {
        this.self().m_20088_().m_135372_(Ship.SHIELD_DATA, (Object)new CompoundTag());
    }

    default public void readShieldShipSaveData(CompoundTag tag) {
        ListTag shieldItems = tag.m_128437_("Shields", 10);
        for (int i = 0; i < shieldItems.size(); ++i) {
            CompoundTag compoundnbt = shieldItems.m_128728_(i);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundnbt);
            this.self().SHIELDS.push(itemStack);
        }
        this.self().setShieldData(tag);
    }

    default public void addShieldShipSaveData(CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.self().SHIELDS.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.self().SHIELDS.get(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Shields", (byte)i);
            itemstack.m_41739_(compoundnbt);
            listTag.add((Object)compoundnbt);
        }
        tag.m_128365_("Shields", (Tag)listTag);
        this.self().setShieldData(tag);
    }

    default public Stack<ItemStack> getShields() {
        if (this.self().SHIELDS.isEmpty() && !this.self().getShieldData().m_128456_() && this.self().m_20193_().m_5776_()) {
            this.readShieldShipSaveData(this.self().getShieldData());
        }
        return this.self().SHIELDS;
    }

    default public float getDamageModifier() {
        return (float)(1.0 - (double)this.getShields().size() * (Double)SmallShipsConfig.Common.shipGeneralShieldDamageReduction.get() / 100.0);
    }

    default public boolean interactShield(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        int shieldCount = this.getShields().size();
        if (itemStack.m_150930_(Items.f_42740_)) {
            if (shieldCount >= this.getMaxShieldsPerSide() * 2) {
                return false;
            }
            this.getShields().push(itemStack.m_41777_());
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            this.self().m_9236_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_12634_, this.self().m_5720_(), 15.0f, 1.5f);
            return true;
        }
        if (itemStack.m_41720_() instanceof AxeItem && shieldCount > 0) {
            ItemStack removedShield = this.getShields().pop();
            this.self().m_5552_(removedShield, 2.0f);
            this.self().m_9236_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_12634_, this.self().m_5720_(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static class ShieldPosition {
        public final double x;
        public final double y;
        public final double z;
        public final boolean isRightSided;

        public ShieldPosition(double x, double y, double z, boolean isRightSided) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.isRightSided = isRightSided;
        }
    }
}

