/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.math.Kalkuel;
import com.talhanation.smallships.mixin.controlling.BoatAccessor;
import com.talhanation.smallships.network.ModPackets;
import com.talhanation.smallships.world.damagesource.ModDamageSourceTypes;
import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.IceBreakable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Ship
extends Boat {
    public static final EntityDataAccessor<CompoundTag> ATTRIBUTES = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROT_SPEED = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Byte> SAIL_STATE = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<String> SAIL_COLOR = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<ItemStack> BANNER = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Float> CANNON_POWER = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Byte> CANNON_COUNT = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FORWARD = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BACKWARD = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SUNKEN = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<CompoundTag> SHIELD_DATA = SynchedEntityData.m_135353_(Ship.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private boolean isLocked = false;
    private int sunkenTime = 0;
    private float prevWaveAngle;
    private float waveAngle;
    public float prevBannerWaveAngle;
    public float bannerWaveAngle;
    protected boolean cannonKeyPressed;
    public int sailStateCooldown = 0;
    private float setPoint;
    public final List<Cannon> CANNONS = new ArrayList<Cannon>();
    public final Stack<ItemStack> SHIELDS = new Stack();
    public float maxSpeed;
    private CameraType previousCameraType;

    public Ship(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
        if (this.m_7770_() == null) {
            this.m_6593_((Component)Component.m_237113_((String)StringUtils.capitalize((String)EntityType.m_20613_((EntityType)this.m_6095_()).m_135815_())));
        }
        this.f_19793_ = 0.6f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_38384_() > 0.0f) {
            this.m_38311_(this.m_38384_() + 1.0f);
        }
        if (this.isSunken()) {
            int n;
            ++this.sunkenTime;
            if ((double)n > (Double)SmallShipsConfig.Common.shipGeneralDespawnTimeSunken.get() * 20.0 * 60.0) {
                this.m_213560_(DamageSource.f_19312_);
            } else {
                this.m_20334_(this.m_20184_().f_82479_, -0.2, this.m_20184_().f_82481_);
            }
        } else {
            Ship ship = this;
            if (ship instanceof Sailable) {
                Sailable sailShip = (Sailable)((Object)ship);
                sailShip.tickSailShip();
            }
            if ((ship = this) instanceof Bannerable) {
                Bannerable bannerShip = (Bannerable)((Object)ship);
                bannerShip.tickBannerShip();
            }
            if ((ship = this) instanceof Cannonable) {
                Cannonable cannonShip = (Cannonable)((Object)ship);
                cannonShip.tickCannonShip();
            }
            if ((ship = this) instanceof Paddleable) {
                Paddleable paddleShip = (Paddleable)((Object)ship);
                paddleShip.tickPaddleShip();
            }
            if ((ship = this) instanceof Shieldable) {
                Shieldable shieldShip = (Shieldable)((Object)ship);
                shieldShip.tickShieldShip();
            }
            if ((ship = this) instanceof IceBreakable) {
                IceBreakable iceBreakable = (IceBreakable)((Object)ship);
                iceBreakable.tickIceBreakable();
            }
            boolean isCruising = this.getSpeed() > 0.085f || this.getSpeed() < -0.085f;
            this.updateShipAmbience(isCruising);
            this.updateCollision(isCruising);
            this.updateWaveAngle();
            this.updateWaterMobs();
            this.floatUp();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(ROT_SPEED, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(ATTRIBUTES, (Object)this.createDefaultAttributes());
        this.m_20088_().m_135372_(FORWARD, (Object)false);
        this.m_20088_().m_135372_(BACKWARD, (Object)false);
        this.m_20088_().m_135372_(LEFT, (Object)false);
        this.m_20088_().m_135372_(RIGHT, (Object)false);
        this.m_20088_().m_135372_(SUNKEN, (Object)false);
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.defineSailShipSynchedData();
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.defineBannerShipSynchedData();
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.defineCannonShipSynchedData();
        }
        if ((ship = this) instanceof Shieldable) {
            Shieldable shieldShip = (Shieldable)((Object)ship);
            shieldShip.defineShieldShipSynchedData();
        }
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(tag, this);
        this.setData(ATTRIBUTES, attributes.getSaveData());
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.readSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.readBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.readCannonShipSaveData(tag);
        }
        if ((ship = this) instanceof Shieldable) {
            Shieldable shieldShip = (Shieldable)((Object)ship);
            shieldShip.readShieldShipSaveData(tag);
        }
        this.setSunken(tag.m_128471_("Sunken"));
        this.isLocked = tag.m_128471_("locked");
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        attributes.addSaveData(tag);
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.addSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.addBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.addCannonShipSaveData(tag);
        }
        if ((ship = this) instanceof Shieldable) {
            Shieldable shieldShip = (Shieldable)((Object)ship);
            shieldShip.addShieldShipSaveData(tag);
        }
        tag.m_128379_("Sunken", this.isSunken());
        tag.m_128379_("locked", this.isLocked);
    }

    public <T> T getData(EntityDataAccessor<T> accessor) {
        return (T)this.m_20088_().m_135370_(accessor);
    }

    public boolean m_7310_(Entity entity) {
        return super.m_7310_(entity) && !(entity instanceof Ship) && !((List)SmallShipsConfig.Common.mountBlackList.get()).contains(entity.m_20078_()) && !this.isLocked() && this.m_20197_().size() < this.m_213801_() && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal);
    }

    public <T> void setData(EntityDataAccessor<T> accessor, T value) {
        this.m_20088_().m_135381_(accessor, value);
    }

    protected void m_38396_() {
        Player player;
        float f;
        float f2;
        float f3;
        Attributes attributes = this.getAttributes();
        float f4 = 1.0f + this.getBiomeModifier() / 100.0f;
        Ship ship = this;
        if (ship instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            f3 = cannonShip.getCannonModifier() / 100.0f;
        } else {
            f3 = 0.0f;
        }
        float f5 = f4 * (1.0f - f3);
        ship = this;
        if (ship instanceof ContainerShip) {
            ContainerShip containerShip = (ContainerShip)ship;
            f2 = containerShip.getContainerModifier() / 100.0f;
        } else {
            f2 = 0.0f;
        }
        float f6 = f5 * (1.0f - f2);
        ship = this;
        if (ship instanceof Paddleable) {
            Paddleable paddleShip = (Paddleable)((Object)ship);
            f = paddleShip.getPaddlingModifier() / 100.0f;
        } else {
            f = 0.0f;
        }
        float speedModifier = f6 * (1.0f + f);
        this.maxSpeed = attributes.maxSpeed / 69.0f * speedModifier;
        float maxRotSp = attributes.maxRotationSpeed * 0.1f + 1.8f;
        float acceleration = attributes.acceleration;
        float rotAcceleration = attributes.rotationAcceleration;
        if (this.f_19853_.m_5776_() && !this.isSunken() && (player = this.getDriver()) != null) {
            this.updateControls(((BoatAccessor)((Object)this)).isInputUp(), ((BoatAccessor)((Object)this)).isInputDown(), ((BoatAccessor)((Object)this)).isInputLeft(), ((BoatAccessor)((Object)this)).isInputRight(), player);
        }
        if (this.m_20069_() && !this.isShipLeashed() && !this.isSunken() && !this.isLocked()) {
            Sailable sailShip;
            Ship ship2;
            if (this instanceof Paddleable && (ship2 = this) instanceof Sailable) {
                Sailable sailShip2 = (Sailable)((Object)ship2);
                if (this.isForward() && this.getDriver() != null) {
                    this.setPoint = this.maxSpeed * 12.0f / 16.0f * (1.0f + (float)(1 + sailShip2.getSailState()) * 0.1f);
                } else {
                    switch (sailShip2.getSailState()) {
                        case 0: {
                            this.setPoint = 0.0f;
                            break;
                        }
                        case 1: {
                            this.setPoint = this.maxSpeed * 4.0f / 16.0f;
                            break;
                        }
                        case 2: {
                            this.setPoint = this.maxSpeed * 8.0f / 16.0f;
                            break;
                        }
                        case 3: {
                            this.setPoint = this.maxSpeed * 12.0f / 16.0f;
                            break;
                        }
                        case 4: {
                            this.setPoint = this.maxSpeed * 16.0f / 16.0f;
                        }
                    }
                }
            } else {
                ship2 = this;
                if (ship2 instanceof Sailable) {
                    sailShip = (Sailable)((Object)ship2);
                    switch (sailShip.getSailState()) {
                        case 0: {
                            this.setPoint = 0.0f;
                            break;
                        }
                        case 1: {
                            this.setPoint = this.maxSpeed * 4.0f / 16.0f;
                            break;
                        }
                        case 2: {
                            this.setPoint = this.maxSpeed * 8.0f / 16.0f;
                            break;
                        }
                        case 3: {
                            this.setPoint = this.maxSpeed * 12.0f / 16.0f;
                            break;
                        }
                        case 4: {
                            this.setPoint = this.maxSpeed * 16.0f / 16.0f;
                        }
                    }
                }
            }
            this.calculateSpeed(acceleration);
            float rotationSpeed = Kalkuel.subtractToZero(this.getRotSpeed(), this.getVelocityResistance() * 2.5f);
            if (this.getDriver() != null) {
                if (this.isRight() && rotationSpeed < maxRotSp) {
                    rotationSpeed = Math.min(rotationSpeed + rotAcceleration * 1.0f / 8.0f, maxRotSp);
                }
                if (this.isLeft() && rotationSpeed > -maxRotSp) {
                    rotationSpeed = Math.max(rotationSpeed - rotAcceleration * 1.0f / 8.0f, -maxRotSp);
                }
            }
            this.setRotSpeed(rotationSpeed);
            ((BoatAccessor)((Object)this)).setDeltaRotation(rotationSpeed);
            this.m_146922_(this.m_146908_() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            if (this.getDriver() != null) {
                ship2 = this;
                if (ship2 instanceof Sailable) {
                    sailShip = (Sailable)((Object)ship2);
                    sailShip.controlBoatSailShip();
                }
                if ((ship2 = this) instanceof Paddleable) {
                    Paddleable paddleShip = (Paddleable)((Object)ship2);
                    paddleShip.controlBoatPaddleShip();
                }
            }
            this.m_20334_(Kalkuel.calculateMotionX(this.getSpeed(), this.m_146908_()), this.m_20184_().f_82480_, Kalkuel.calculateMotionZ(this.getSpeed(), this.m_146908_()));
        } else {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isShipLeashed() {
        return ((BoatLeashAccess)((Object)this)).isLeashed();
    }

    private void calculateSpeed(float acceleration) {
        float speed = this.getSpeed();
        speed = speed < this.setPoint ? Kalkuel.addToSetPoint(speed, acceleration, this.setPoint) : Kalkuel.subtractToZero(speed, this.getVelocityResistance() * 0.8f);
        if (this.isLeft() || this.isRight()) {
            speed *= 1.0f - Mth.m_14154_((float)this.getRotSpeed()) * 0.02f;
        }
        this.setSpeed(speed);
    }

    public CompoundTag getShieldData() {
        return (CompoundTag)this.f_19804_.m_135370_(SHIELD_DATA);
    }

    public void setShieldData(CompoundTag f) {
        this.f_19804_.m_135381_(SHIELD_DATA, (Object)f);
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
    }

    public float getRotSpeed() {
        return ((Float)this.f_19804_.m_135370_(ROT_SPEED)).floatValue();
    }

    public void setSpeed(float f) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(f));
    }

    public void setRotSpeed(float f) {
        this.f_19804_.m_135381_(ROT_SPEED, (Object)Float.valueOf(f));
    }

    public void setForward(boolean forward) {
        this.f_19804_.m_135381_(FORWARD, (Object)forward);
    }

    public void setBackward(boolean backward) {
        this.f_19804_.m_135381_(BACKWARD, (Object)backward);
    }

    public void setLeft(boolean left) {
        this.f_19804_.m_135381_(LEFT, (Object)left);
    }

    public void setRight(boolean right) {
        this.f_19804_.m_135381_(RIGHT, (Object)right);
    }

    public boolean isForward() {
        if (this.m_6688_() == null) {
            return false;
        }
        return (Boolean)this.f_19804_.m_135370_(FORWARD);
    }

    public boolean isBackward() {
        if (this.m_6688_() == null) {
            return false;
        }
        return (Boolean)this.f_19804_.m_135370_(BACKWARD);
    }

    public boolean isLeft() {
        return (Boolean)this.f_19804_.m_135370_(LEFT);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT);
    }

    public float getBiomeModifier() {
        boolean warmType;
        BiomeModifierType shipBiomeType = this.getBiomeModifierType();
        if (shipBiomeType == BiomeModifierType.NONE) {
            return 0.0f;
        }
        BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
        int tmp = ((Biome)this.m_9236_().m_204166_(pos).m_203334_()).m_47560_();
        float modifier = ((Double)SmallShipsConfig.Common.shipGeneralBiomeModifier.get()).floatValue();
        boolean coldBiomes = tmp < 4100000;
        boolean warmBiomes = tmp > 4300000;
        boolean neutralBiomes = !coldBiomes && !warmBiomes;
        boolean coldType = shipBiomeType == BiomeModifierType.COLD;
        boolean neutralType = shipBiomeType == BiomeModifierType.NEUTRAL;
        boolean bl = warmType = shipBiomeType == BiomeModifierType.WARM;
        if (coldBiomes && coldType || warmBiomes && warmType || neutralBiomes && neutralType) {
            return modifier;
        }
        if (coldBiomes && warmType || warmBiomes && coldType || (coldBiomes || warmBiomes) && neutralType) {
            return -modifier;
        }
        if (neutralBiomes && warmType || neutralBiomes && coldType) {
            return -modifier / 4.0f;
        }
        return 0.0f;
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!this.isLocked()) {
            Shieldable shieldShip;
            Bannerable bannerShip;
            Sailable sailShip;
            Cannonable cannonShip;
            if (this.interactWithNameTag(player)) {
                return InteractionResult.SUCCESS;
            }
            if (this.interactIronNuggets(player)) {
                return InteractionResult.SUCCESS;
            }
            Ship ship = this;
            if (ship instanceof Cannonable && (cannonShip = (Cannonable)((Object)ship)).interactCannon(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            ship = this;
            if (ship instanceof Sailable && (sailShip = (Sailable)((Object)ship)).interactSail(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            ship = this;
            if (ship instanceof Bannerable && (bannerShip = (Bannerable)((Object)ship)).interactBanner(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            ship = this;
            if (ship instanceof Shieldable && (shieldShip = (Shieldable)((Object)ship)).interactShield(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            return super.m_6096_(player, interactionHand);
        }
        return InteractionResult.PASS;
    }

    private boolean interactWithNameTag(@NotNull Player player) {
        if (player.m_21205_().m_150930_(Items.f_42656_) && player.m_21205_().m_41788_() && !player.m_20193_().f_46443_) {
            this.m_6593_(player.m_21205_().m_41786_());
            this.m_20340_(false);
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private boolean interactIronNuggets(@NotNull Player player) {
        if (this.m_38384_() > 0.0f && player.m_21205_().m_150930_(Items.f_42749_) && player.m_150109_().m_216874_(stack -> stack.m_204117_(ItemTags.f_13168_))) {
            this.repairShip(5 + this.f_19853_.f_46441_.m_188503_(5));
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(1);
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack itemStack = player.m_150109_().m_8020_(i);
                    if (!itemStack.m_204117_(ItemTags.f_13168_)) continue;
                    itemStack.m_41774_(1);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void repairShip(int repairAmount) {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * this.f_19853_.m_213780_().m_188501_());
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * this.f_19853_.m_213780_().m_188501_());
        float newDamage = this.m_38384_() - (float)repairAmount;
        if (newDamage < 0.0f) {
            newDamage = 0.0f;
        }
        this.m_38311_(newDamage);
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity livingEntity) {
        Sailable sailShip;
        Ship ship = this;
        if (ship instanceof Sailable && (sailShip = (Sailable)((Object)ship)).getSailState() != 0) {
            sailShip.toggleSail();
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_20348_(Entity entity) {
        if (this.m_9236_().m_5776_() && ((Boolean)SmallShipsConfig.Client.shipGeneralCameraAutoThirdPerson.get()).booleanValue() && Objects.equals(Minecraft.m_91087_().f_91074_, entity)) {
            this.previousCameraType = Minecraft.m_91087_().f_91066_.m_92176_();
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        }
        super.m_20348_(entity);
    }

    protected void m_20351_(Entity entity) {
        if (this.m_9236_().m_5776_() && ((Boolean)SmallShipsConfig.Client.shipGeneralCameraAutoThirdPerson.get()).booleanValue() && Objects.equals(Minecraft.m_91087_().f_91074_, entity)) {
            Minecraft.m_91087_().f_91066_.m_92157_(this.previousCameraType);
        }
        super.m_20351_(entity);
    }

    public void setSunken(boolean sunken) {
        this.f_19804_.m_135381_(SUNKEN, (Object)sunken);
    }

    public boolean isSunken() {
        return (Boolean)this.f_19804_.m_135370_(SUNKEN);
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.75;
    }

    private void updateWaveAngle() {
        this.prevWaveAngle = this.waveAngle;
        this.waveAngle = (float)Math.sin(this.getWaveSpeed() * (float)this.f_19797_) * this.getWaveFactor();
    }

    private float getWaveFactor() {
        return this.m_9236_().m_46471_() ? 3.0f : 1.25f;
    }

    private float getWaveSpeed() {
        return this.m_9236_().m_46471_() ? 0.12f : 0.03f;
    }

    public float getWaveAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevWaveAngle, (float)this.waveAngle);
    }

    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        return attributes;
    }

    public void setCannonKeyPressed(boolean b) {
        this.cannonKeyPressed = b;
    }

    public boolean isCannonKeyPressed() {
        return this.cannonKeyPressed;
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_().m_82400_(5.0);
    }

    public abstract int m_213801_();

    @NotNull
    public abstract Item m_38369_();

    public abstract BiomeModifierType getBiomeModifierType();

    public abstract CompoundTag createDefaultAttributes();

    public float getVelocityResistance() {
        return 0.007f;
    }

    protected void waterSplash() {
    }

    private void updateShipAmbience(boolean isSwimming) {
        if (isSwimming && this.m_20069_()) {
            this.waterSplash();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11918_, this.m_5720_(), 0.05f, 0.8f + 0.4f * this.f_19796_.m_188501_());
        }
    }

    private void updateWaterMobs() {
        if (!this.m_20193_().m_5776_()) {
            double radius = (Double)SmallShipsConfig.Common.waterAnimalFleeRadius.get();
            List waterAnimals = this.m_9236_().m_45976_(WaterAnimal.class, new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius));
            for (WaterAnimal waterAnimal : waterAnimals) {
                if (this.f_19797_ % 20 != 0) continue;
                this.fleeEntity((Mob)waterAnimal);
            }
        }
    }

    private void fleeEntity(Mob entity) {
        double fleeDistance = (Double)SmallShipsConfig.Common.waterAnimalFleeDistance.get();
        double fleeSpeed = (Double)SmallShipsConfig.Common.waterAnimalFleeSpeed.get();
        Vec3 vecBoat = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 vecEntity = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 fleeDir = vecEntity.m_82546_(vecBoat);
        fleeDir = fleeDir.m_82541_();
        Vec3 fleePos = new Vec3(vecEntity.f_82479_ + fleeDir.f_82479_ * fleeDistance, vecEntity.f_82480_ + fleeDir.f_82480_ * fleeDistance, vecEntity.f_82481_ + fleeDir.f_82481_ * fleeDistance);
        entity.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, fleeSpeed);
    }

    protected void floatUp() {
        if (this.m_204029_(FluidTags.f_13131_)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.2, 0.0));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource damageSource, float f) {
        block9: {
            if (this.m_6673_(damageSource)) {
                return false;
            }
            if (this.m_9236_().m_5776_() || this.m_213877_()) break block9;
            v0 = this.m_38384_();
            var4_3 = this;
            if (var4_3 instanceof Shieldable) {
                shieldShip = (Shieldable)var4_3;
                v1 = shieldShip.getDamageModifier();
            } else {
                v1 = 1.0f;
            }
            this.m_38311_(v0 + f * v1);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
            var5_6 = damageSource.m_7639_();
            if (!(var5_6 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_6;
            if (player.m_150110_().f_35937_ && player.m_6047_()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = bl = false;
            }
            if (this.m_38384_() > this.getAttributes().maxHealth) {
                if (this.isSunken() && this.sunkenTime > 200) {
                    this.m_213560_(DamageSource.f_19312_);
                } else {
                    this.setSunken(true);
                }
            }
            if (bl) {
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    private void knockBack(Entity entity, double speed, AABB boundingBox) {
        double d0 = (boundingBox.f_82288_ + boundingBox.f_82291_) / 2.0;
        double d1 = (boundingBox.f_82290_ + boundingBox.f_82293_) / 2.0;
        if (entity instanceof LivingEntity) {
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_20256_(this.m_20184_().m_82520_(d2 / d4 * (1.0 + speed * 1.1), 0.0, d3 / d4 * (1.0 + speed * 1.1)));
        }
    }

    private void updateCollision(boolean isCruising) {
        if (isCruising && this.canDoKnockBack() && ((Boolean)SmallShipsConfig.Common.shipGeneralCollisionKnockBack.get()).booleanValue()) {
            AABB boundingBox = this.m_20191_().m_82377_(2.25, 1.25, 2.25).m_82386_(0.0, -2.0, 0.0);
            List list = this.f_19853_.m_6249_((Entity)this, boundingBox, EntitySelector.m_20421_((Entity)this));
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity) || this.m_20197_().contains(entity)) continue;
                this.knockBack(entity, this.getSpeed(), boundingBox);
                this.collisionDamage(entity, this.getSpeed());
            }
        }
    }

    public boolean canDoKnockBack() {
        return true;
    }

    public boolean canDoCollisionDamage() {
        return true;
    }

    private void collisionDamage(Entity hitEntity, float speed) {
        if (this.canDoCollisionDamage() && speed > 0.1f) {
            Entity driver = this.m_6688_();
            if (driver != null && driver.m_5647_() != null && driver.m_5647_().m_83536_(hitEntity.m_5647_()) && !driver.m_5647_().m_6260_()) {
                return;
            }
            float damage = speed * ((Double)SmallShipsConfig.Common.shipGeneralCollisionDamage.get()).floatValue();
            if (damage > 0.0f) {
                hitEntity.m_6469_(ModDamageSourceTypes.shipCollision(this, this.m_6688_()), damage);
            }
        }
    }

    @Nullable
    public Player getDriver() {
        List passengers = this.m_20197_();
        if (passengers.isEmpty()) {
            return null;
        }
        Object e = passengers.get(0);
        if (e instanceof Player) {
            Player player = (Player)e;
            if (this.f_19853_.f_46443_) {
                Minecraft minecraft = Minecraft.m_91087_();
                LocalPlayer instancePlayer = minecraft.f_91074_;
                return player.equals((Object)instancePlayer) ? player : null;
            }
            return (Player)passengers.get(0);
        }
        return null;
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, @Nullable Player player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.m_20193_().f_46443_ && needsUpdate && player != null) {
            ModPackets.clientSendPacket(player, ModPackets.serverUpdateShipControl.apply(forward, backward, left, right));
        }
    }

    public void m_213560_(@NotNull DamageSource damageSource) {
        super.m_213560_(damageSource);
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            Ship ship = this;
            if (ship instanceof ContainerShip) {
                ContainerShip containerShip = (ContainerShip)ship;
                containerShip.m_219927_(damageSource, this.m_9236_(), (Entity)this);
            }
            if ((ship = this) instanceof Cannonable) {
                Cannonable cannonableShip = (Cannonable)((Object)ship);
                cannonableShip.cannonShipDestroyed(this.m_20193_(), this);
            }
        }
        this.m_146870_();
    }

    public static enum BiomeModifierType {
        NONE,
        COLD,
        NEUTRAL,
        WARM;

    }
}

