/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.projectile;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.damagesource.ModDamageSourceTypes;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCannonBall
extends AbstractHurtingProjectile {
    public boolean inWater = false;
    public boolean wasShot = false;
    public int counter = 0;

    protected AbstractCannonBall(EntityType<? extends AbstractCannonBall> type, Level world) {
        super(type, world);
    }

    public AbstractCannonBall(EntityType<? extends AbstractCannonBall> type, LivingEntity owner, double d1, double d2, double d3, Level world) {
        super(type, owner, d1, d2, d3, world);
        this.m_7678_(d1, d2, d3, this.m_146908_(), this.m_146909_());
    }

    public void m_8119_() {
        this.m_6075_();
        Vec3 vector3d = this.m_20184_();
        HitResult raytraceresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(raytraceresult);
        }
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        this.m_37283_();
        float f = 0.99f;
        float f1 = 0.06f;
        float f2 = -0.05f;
        this.m_20256_(vector3d.m_82490_((double)f));
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-f1), 0.0));
        }
        this.m_6034_(d0, d1, d2);
        if (this.m_6084_()) {
            this.setWasShot(true);
        }
        if (this.m_20069_()) {
            if (this.m_9236_().m_5776_() && !this.m_5842_()) {
                this.waterParticles();
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-f2), 0.0));
            this.setInWater(true);
        }
        if (this.wasShot) {
            ++this.counter;
        }
        if (this.counter < 4 && this.m_9236_().m_5776_()) {
            this.tailParticles();
        }
        if (this.m_20069_() && this.counter > 200) {
            this.m_146870_();
        }
    }

    public void setWasShot(boolean bool) {
        if (bool != this.wasShot) {
            this.wasShot = true;
            if (this.m_9236_().m_5776_()) {
                this.shootParticles();
            }
        }
    }

    public void setInWater(boolean bool) {
        if (bool != this.inWater) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11917_, SoundSource.BLOCKS, 3.3f, 0.8f + 0.4f * this.f_19796_.m_188501_());
            this.inWater = true;
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().m_5776_()) {
            Explosion.BlockInteraction blockInteraction = this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            boolean doesSpreadFire = false;
            if (!this.m_20069_()) {
                this.m_9236_().m_46518_(this.m_37282_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Double)SmallShipsConfig.Common.shipGeneralCannonDestruction.get()).floatValue(), doesSpreadFire, blockInteraction);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.hitParticles();
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.m_9236_().m_5776_()) {
            Entity hitEntity = hitResult.m_82443_();
            Entity ownerEntity = this.m_37282_();
            if (hitEntity instanceof Ship) {
                Ship shipHitEntity = (Ship)hitEntity;
                shipHitEntity.m_6469_(ModDamageSourceTypes.cannonBall(this, ownerEntity), this.f_19796_.m_188503_(7) + 7);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), ModSoundTypes.SHIP_HIT, this.m_5720_(), 3.3f, 0.8f + 0.4f * this.f_19796_.m_188501_());
            } else if (ownerEntity instanceof LivingEntity) {
                LivingEntity livingOwnerEntity = (LivingEntity)ownerEntity;
                if (ownerEntity.m_5647_() != null && ownerEntity.m_5647_().m_83536_(hitEntity.m_5647_()) && !ownerEntity.m_5647_().m_6260_()) {
                    return;
                }
                this.m_19970_(livingOwnerEntity, hitEntity);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 3.3f, 0.8f + 0.4f * this.f_19796_.m_188501_());
            }
            hitEntity.m_6469_(ModDamageSourceTypes.cannonBall(this, ownerEntity), ((Double)SmallShipsConfig.Common.shipGeneralCannonDamage.get()).floatValue());
        }
    }

    public void hitParticles() {
        for (int i = 0; i < 300; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.03;
            double d1 = this.f_19796_.m_188583_() * 0.03;
            double d2 = this.f_19796_.m_188583_() * 0.03;
            double d3 = 20.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20165_(1.0) - d0 * d3, this.m_20187_() - d1 * d3, this.m_20262_(2.0) - d2 * d3, d0, d1, d2);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20165_(1.0) - d0 * d3, this.m_20187_() - d1 * d3, this.m_20262_(2.0) - d2 * d3, d0, d1, d2);
        }
    }

    public void waterParticles() {
        for (int i = 0; i < 200; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.03;
            double d1 = this.f_19796_.m_188583_() * 0.03;
            double d2 = this.f_19796_.m_188583_() * 0.03;
            double d3 = 20.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20165_(1.0) - d0 * d3, this.m_20187_() - d1 * d3 + (double)i * 0.012, this.m_20262_(2.0) - d2 * d3, d0, d1, d2);
        }
    }

    public void shootParticles() {
        int i;
        for (i = 0; i < 100; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.03;
            double d1 = this.f_19796_.m_188583_() * 0.03;
            double d2 = this.f_19796_.m_188583_() * 0.03;
            double d3 = 20.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20165_(1.0) - d0 * d3, this.m_20187_() - d1 * d3, this.m_20262_(2.0) - d2 * d3, d0, d1, d2);
        }
        for (i = 0; i < 50; ++i) {
            double d00 = this.f_19796_.m_188583_() * 0.03;
            double d11 = this.f_19796_.m_188583_() * 0.03;
            double d22 = this.f_19796_.m_188583_() * 0.03;
            double d44 = 10.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20165_(1.0) - d00 * d44, this.m_20187_() - d11 * d44, this.m_20262_(2.0) - d22 * d44, d00, d11, d22);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20165_(1.0) - d00 * d44, this.m_20187_() - d11 * d44, this.m_20262_(2.0) - d22 * d44, 0.0, 0.0, 0.0);
        }
    }

    public void tailParticles() {
        int i;
        for (i = 0; i < 100; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 50; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    @NotNull
    public Packet<?> m_5654_() {
        Entity entity = this.m_37282_();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, new Vec3(this.f_36813_, this.f_36814_, this.f_36815_), 0.0);
    }

    protected boolean m_5931_() {
        return false;
    }

    @NotNull
    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123762_;
    }
}

