/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.mixin.leashing;

import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.world.entity.ship.abilities.Leashable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    private Entity self() {
        return (Entity)this;
    }

    @Inject(method={"removeAfterChangingDimensions"}, at={@At(value="RETURN")})
    private void removeAfterChangingDimensionsLeashedShip(CallbackInfo ci) {
        if (this.self() instanceof Leashable || this.self().getClass().equals(Boat.class)) {
            ((BoatLeashAccess)((Object)this)).dropLeash(true, false);
        }
    }

    @Inject(method={"getLeashOffset"}, at={@At(value="HEAD")}, cancellable=true)
    private void getLeashOffsetLeashedShip(CallbackInfoReturnable<Vec3> cir) {
        Entity entity = this.self();
        if (entity instanceof Leashable) {
            Leashable leashShipEntity = (Leashable)entity;
            @Nullable Vec3 offset = leashShipEntity.applyLeashOffset();
            if (offset != null) {
                cir.setReturnValue((Object)offset);
            }
        } else if (this.self().getClass().equals(Boat.class)) {
            cir.setReturnValue((Object)new Vec3(0.0, (double)this.self().m_20192_(), (double)(this.self().m_20205_() * 0.3f)));
        }
    }
}

