/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.settings;

import com.google.gson.JsonObject;
import daripher.autoleveling.config.Config;
import daripher.autoleveling.settings.LevelingSettings;
import java.util.Optional;

public record EntityLevelingSettings(int startingLevel, int maxLevel, float levelsPerDistance, float levelsPerDeepness, int randomLevelBonus, float levelPowerPerDistance, float levelPowerPerDeepness) implements LevelingSettings
{
    @Override
    public float levelsPerDay() {
        return 0.0f;
    }

    public static EntityLevelingSettings load(JsonObject jsonObject) {
        return new EntityLevelingSettings(jsonObject.get("starting_level").getAsInt(), jsonObject.get("max_level").getAsInt(), jsonObject.get("levels_per_distance").getAsFloat(), jsonObject.get("levels_per_deepness").getAsFloat(), jsonObject.get("random_level_bonus").getAsInt(), EntityLevelingSettings.readOptionalFloat(jsonObject, "level_power_per_distance").orElse(Float.valueOf(((Double)Config.COMMON.defaultLevelPowerPerDistance.get()).floatValue())).floatValue(), EntityLevelingSettings.readOptionalFloat(jsonObject, "level_power_per_deepness").orElse(Float.valueOf(((Double)Config.COMMON.defaultLevelPowerPerDeepness.get()).floatValue())).floatValue());
    }

    private static Optional<Float> readOptionalFloat(JsonObject jsonObject, String name) {
        if (!jsonObject.has(name)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(jsonObject.get(name).getAsFloat()));
    }
}

