/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.config;

import daripher.autoleveling.AutoLevelingMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final Map<Attribute, Float> ATTRIBUTE_BONUSES;

    private static List<List<Object>> getDefaultAttributeBonuses() {
        ArrayList<List<Object>> attributeBonusesList = new ArrayList<List<Object>>();
        attributeBonusesList.add(Arrays.asList("minecraft:generic.movement_speed", 0.001));
        attributeBonusesList.add(Arrays.asList("minecraft:generic.flying_speed", 0.001));
        attributeBonusesList.add(Arrays.asList("minecraft:generic.attack_damage", 0.1));
        attributeBonusesList.add(Arrays.asList("minecraft:generic.armor", 0.1));
        attributeBonusesList.add(Arrays.asList("minecraft:generic.max_health", 0.1));
        attributeBonusesList.add(Arrays.asList("autoleveling:monster.projectile_damage_bonus", 0.1));
        attributeBonusesList.add(Arrays.asList("autoleveling:monster.explosion_damage_bonus", 0.1));
        return attributeBonusesList;
    }

    private static <T> boolean isValidAttributeBonus(T object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Double;
        }
        return false;
    }

    public static Map<Attribute, Float> getAttributeBonuses() {
        if (ATTRIBUTE_BONUSES.isEmpty()) {
            ((List)Config.COMMON.attributesBonuses.get()).forEach(attributeBonusConfig -> {
                ResourceLocation attributeId = new ResourceLocation((String)attributeBonusConfig.get(0));
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeId);
                float attributeBonus = ((Double)attributeBonusConfig.get(1)).floatValue();
                if (attribute == null) {
                    AutoLevelingMod.LOGGER.error("Attribute '" + attributeId + "' can not be found!");
                } else {
                    ATTRIBUTE_BONUSES.put(attribute, Float.valueOf(attributeBonus));
                }
            });
        }
        return ATTRIBUTE_BONUSES;
    }

    static {
        ATTRIBUTE_BONUSES = new HashMap<Attribute, Float>();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> attributesBonuses;
        public final ForgeConfigSpec.ConfigValue<Double> expBonus;
        public final ForgeConfigSpec.ConfigValue<Boolean> alwaysShowLevel;
        public final ForgeConfigSpec.ConfigValue<Boolean> showLevelWhenLookingAt;
        public final ForgeConfigSpec.ConfigValue<List<String>> blacklistedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> whitelistedMobs;
        public final ForgeConfigSpec.ConfigValue<List<String>> blacklistedShownLevels;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultStartingLevel;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultMaxLevel;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelsPerDistance;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelsPerDeepness;
        public final ForgeConfigSpec.ConfigValue<Integer> defaultRandomLevelBonus;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelsPerDay;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelPowerPerDistance;
        public final ForgeConfigSpec.ConfigValue<Double> defaultLevelPowerPerDeepness;

        public Common(ForgeConfigSpec.Builder builder) {
            Predicate<Object> positiveOrZeroDouble = o -> o instanceof Double && (Double)o >= 0.0;
            Predicate<Object> positiveDouble = o -> o instanceof Double && (Double)o > 0.0;
            Predicate<Object> positiveOrZeroInteger = o -> o instanceof Integer && (Integer)o >= 0;
            Predicate<Object> positiveInteger = o -> o instanceof Integer && (Integer)o > 0;
            builder.push("mobs");
            this.blacklistedMobs = builder.define("blacklist", new ArrayList());
            this.whitelistedMobs = builder.define("whitelist", new ArrayList());
            this.alwaysShowLevel = builder.define("always_show_level", false);
            this.showLevelWhenLookingAt = builder.define("show_level_when_looking_at", true);
            this.expBonus = builder.define("exp_bonus_per_level", (Object)0.1);
            this.blacklistedShownLevels = builder.define("hidden_levels", new ArrayList());
            builder.pop();
            builder.push("attributes");
            this.attributesBonuses = builder.defineList("attribute_bonuses", Config::getDefaultAttributeBonuses, Config::isValidAttributeBonus);
            builder.pop();
            builder.push("default_leveling_settings");
            this.defaultStartingLevel = builder.define("starting_level", (Object)1, positiveInteger);
            this.defaultMaxLevel = builder.define("max_level", (Object)0, positiveOrZeroInteger);
            this.defaultLevelsPerDistance = builder.define("levels_per_distance", (Object)0.01, positiveDouble);
            this.defaultLevelsPerDeepness = builder.define("levels_per_deepness", (Object)0.0, positiveOrZeroDouble);
            this.defaultRandomLevelBonus = builder.define("random_level_bonus", (Object)0, positiveOrZeroInteger);
            this.defaultLevelsPerDay = builder.define("levels_per_day", (Object)0.0, positiveOrZeroDouble);
            this.defaultLevelPowerPerDistance = builder.define("level_power_per_distance", (Object)0.0, positiveOrZeroDouble);
            this.defaultLevelPowerPerDeepness = builder.define("level_power_per_deepness", (Object)0.0, positiveOrZeroDouble);
            builder.pop();
        }
    }
}

