/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.other;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import java.util.Calendar;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atmospheric")
public class AtmosphericEvents {
    @SubscribeEvent
    public static void projectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof Snowball) {
            Snowball snowball = (Snowball)projectile;
            HitResult hitResult = event.getRayTraceResult();
            if (hitResult instanceof BlockHitResult) {
                Block newBlock;
                BlockPos pos;
                BlockHitResult result = (BlockHitResult)hitResult;
                Level level = snowball.m_9236_();
                BlockState state = level.m_8055_(pos = result.m_82425_());
                Object object = state.m_60713_(Blocks.f_50572_) ? (Block)AtmosphericBlocks.POTTED_SNOWY_BAMBOO.get() : (state.m_60713_(Blocks.f_50248_) ? (Block)AtmosphericBlocks.POTTED_SNOWY_CACTUS.get() : (newBlock = state.m_60713_((Block)AtmosphericBlocks.POTTED_BARREL_CACTUS.get()) ? (Block)AtmosphericBlocks.POTTED_SNOWY_BARREL_CACTUS.get() : null));
                if (newBlock != null) {
                    level.m_46597_(pos, newBlock.m_49966_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity().m_6095_().m_204039_(AtmosphericEntityTypeTags.CACTUS_IMMUNE) && event.getSource() == DamageSource.f_19314_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingHurt(LivingHurtEvent event) {
        int amplifier;
        LivingEntity entity = event.getEntity();
        boolean undead = entity.m_21222_();
        boolean hasRelief = entity.m_21023_((MobEffect)AtmosphericMobEffects.RELIEF.get());
        boolean hasWorsening = entity.m_21023_((MobEffect)AtmosphericMobEffects.WORSENING.get());
        if (!undead && hasRelief || undead && hasWorsening) {
            amplifier = entity.m_21124_(!undead ? (MobEffect)AtmosphericMobEffects.RELIEF.get() : (MobEffect)AtmosphericMobEffects.WORSENING.get()).m_19564_();
            entity.getPersistentData().m_128405_("PotionHealAmplifier", amplifier);
            entity.getPersistentData().m_128350_("IncomingDamage", event.getAmount());
            entity.getPersistentData().m_128379_("Heal", true);
        }
        if (!undead && hasWorsening || undead && hasRelief) {
            amplifier = entity.m_21124_(!undead ? (MobEffect)AtmosphericMobEffects.WORSENING.get() : (MobEffect)AtmosphericMobEffects.RELIEF.get()).m_19564_();
            if (event.getAmount() >= (float)(amplifier + 1)) {
                event.setAmount(event.getAmount() + (float)(amplifier + 1));
            }
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        float damage = entity.getPersistentData().m_128457_("IncomingDamage");
        int amplifierHeal = entity.getPersistentData().m_128451_("PotionHealAmplifier");
        if (entity.getPersistentData().m_128471_("Heal") && damage >= (float)(amplifierHeal + 1)) {
            entity.m_5634_((float)(amplifierHeal + 1));
            entity.getPersistentData().m_128379_("Heal", false);
        }
        if ((livingEntity = event.getEntity()) instanceof ServerPlayer && !(player = (ServerPlayer)livingEntity).m_20193_().m_5776_() && player.m_21023_((MobEffect)AtmosphericMobEffects.PERSISTENCE.get()) && (float)player.m_36324_().m_38702_() <= 6.0f) {
            AtmosphericCriteriaTriggers.PERSISTENCE_WHILE_STARVING.trigger(player);
        }
    }

    @SubscribeEvent
    public static void onInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            RandomizableContainerBlockEntity container;
            ServerPlayer player2 = (ServerPlayer)player;
            BlockPos pos = event.getPos();
            Level level = event.getLevel();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity && (container = (RandomizableContainerBlockEntity)blockEntity).serializeNBT().m_128461_("LootTable").equals(Atmospheric.location("chests/arid_garden").toString()) && player2.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)AtmosphericItems.BARREL_CACTUS.get()) && !player2.m_20193_().m_5776_()) {
                AtmosphericCriteriaTriggers.LOOT_ARID_GARDEN.trigger(player2);
            }
        }
    }

    public static boolean isAprilFools() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }
}

