/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AtmosphericBiomeModifierProvider {
    private static final RegistryAccess ACCESS = RegistryAccess.m_206197_();
    private static final Registry<Biome> BIOMES = ACCESS.m_175515_(Registry.f_122885_);
    private static final Registry<PlacedFeature> PLACED_FEATURES = ACCESS.m_175515_(Registry.f_194567_);
    private static final HashMap<ResourceLocation, BiomeModifier> MODIFIERS = new HashMap();

    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        AtmosphericBiomeModifierProvider.addFeature("yucca_tree_desert", (ResourceKey<Biome>)Biomes.f_48203_, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.DESERT_YUCCA_TREES);
        AtmosphericBiomeModifierProvider.addFeature("yucca_tree_windswept_savanna", (ResourceKey<Biome>)Biomes.f_186768_, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.WINDSWEPT_SAVANNA_YUCCA_TREES);
        AtmosphericBiomeModifierProvider.addFeature("wooded_badlands_vegetation", (ResourceKey<Biome>)Biomes.f_186753_, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.WOODED_BADLANDS_YUCCA_TREES, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_AGAVE_WOODED_BADLANDS);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"atmospheric", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)ACCESS), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, MODIFIERS);
    }

    @SafeVarargs
    private static void addFeature(String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        AtmosphericBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(AtmosphericBiomeModifierProvider.biomeSet(biome), AtmosphericBiomeModifierProvider.featureSet(features), step));
    }

    @SafeVarargs
    private static void addFeature(String name, TagKey<Biome> biomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        AtmosphericBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, biomes), AtmosphericBiomeModifierProvider.featureSet(features), step));
    }

    private static void addModifier(String name, BiomeModifier modifier) {
        MODIFIERS.put(new ResourceLocation("atmospheric", name), modifier);
    }

    @SafeVarargs
    private static HolderSet<Biome> biomeSet(ResourceKey<Biome> ... biomes) {
        return HolderSet.m_205800_(Stream.of(biomes).map(arg_0 -> BIOMES.m_214121_(arg_0)).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

