/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core;

import com.teamabnormals.atmospheric.client.model.CochinealModel;
import com.teamabnormals.atmospheric.client.model.DragonFruitModel;
import com.teamabnormals.atmospheric.client.model.PassionFruitSeedModel;
import com.teamabnormals.atmospheric.client.renderer.entity.CochinealRenderer;
import com.teamabnormals.atmospheric.client.renderer.entity.DragonFruitRenderer;
import com.teamabnormals.atmospheric.client.renderer.entity.PassionFruitSeedRenderer;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericBlockStateProvider;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericItemModelProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericAdvancementProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericLootTableProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericRecipeProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericStructureRepaletterProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericAdvancementModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericBiomeModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericChunkGeneratorModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericLootModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericModdedBiomeSliceProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBannerPatternTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBiomeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBlockTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericEntityTypeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericItemTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericStructureTagsProvider;
import com.teamabnormals.atmospheric.core.other.AtmosphericClientCompat;
import com.teamabnormals.atmospheric.core.other.AtmosphericCompat;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import com.teamabnormals.atmospheric.core.other.AtmosphericVillagers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBannerPatterns;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import com.teamabnormals.atmospheric.core.registry.AtmosphericLootConditions;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.AtmosphericNoiseParameters;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericPlacementModifierTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericStructureProcessors;
import com.teamabnormals.atmospheric.core.registry.helper.AtmosphericBlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="atmospheric")
@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Atmospheric {
    public static final String MOD_ID = "atmospheric";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"atmospheric", helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new AtmosphericBlockSubRegistryHelper((RegistryHelper)helper)));

    public Atmospheric() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        AtmosphericFeatures.FEATURES.register(bus);
        AtmosphericFeatures.TREE_DECORATOR_TYPES.register(bus);
        AtmosphericFeatures.AtmosphericConfiguredFeatures.CONFIGURED_FEATURES.register(bus);
        AtmosphericFeatures.AtmosphericPlacedFeatures.PLACED_FEATURES.register(bus);
        AtmosphericNoiseParameters.NOISE_PARAMETERS.register(bus);
        AtmosphericPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register(bus);
        AtmosphericParticleTypes.PARTICLES.register(bus);
        AtmosphericMobEffects.EFFECTS.register(bus);
        AtmosphericMobEffects.POTIONS.register(bus);
        AtmosphericLootConditions.LOOT_CONDITION_TYPES.register(bus);
        AtmosphericBannerPatterns.BANNER_PATTERNS.register(bus);
        AtmosphericStructureProcessors.STRUCTURE_PROCESSORS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtmosphericConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AtmosphericVillagers.registerVillagerTypes();
            AtmosphericCompat.registerCompat();
            AtmosphericMobEffects.registerBrewingRecipes();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> AtmosphericClientCompat.registerCompat());
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        AtmosphericBlockTagsProvider blockTags = new AtmosphericBlockTagsProvider(generator, helper);
        generator.m_236039_(includeServer, (DataProvider)blockTags);
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericItemTagsProvider(generator, blockTags, helper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericEntityTypeTagsProvider(generator, helper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericBiomeTagsProvider(generator, helper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericBannerPatternTagsProvider(generator, helper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericStructureTagsProvider(generator, helper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericLootTableProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericRecipeProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericAdvancementProvider(generator, helper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericAdvancementModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericLootModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericStructureRepaletterProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericChunkGeneratorModifierProvider(generator));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericModdedBiomeSliceProvider(generator));
        generator.m_236039_(includeServer, AtmosphericBiomeModifierProvider.create(generator, helper));
        boolean includeClient = event.includeClient();
        generator.m_236039_(includeClient, (DataProvider)new AtmosphericBlockStateProvider(generator, helper));
        generator.m_236039_(includeServer, (DataProvider)new AtmosphericItemModelProvider(generator, helper));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AtmosphericModelLayers.COCHINEAL, () -> CochinealModel.createBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(AtmosphericModelLayers.COCHINEAL_SADDLE, () -> CochinealModel.createBodyLayer(new CubeDeformation(0.5f)));
        event.registerLayerDefinition(AtmosphericModelLayers.PASSION_FRUIT_SEED, PassionFruitSeedModel::createBodyLayer);
        event.registerLayerDefinition(AtmosphericModelLayers.DRAGON_FRUIT, DragonFruitModel::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.COCHINEAL.get(), CochinealRenderer::new);
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.PASSION_FRUIT_SEED.get(), PassionFruitSeedRenderer::new);
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.DRAGON_FRUIT.get(), DragonFruitRenderer::new);
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.ORANGE_VAPOR_CLOUD.get(), NoopRenderer::new);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

