/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LayerLightEngine;

public interface Crustose {
    public Block getUnspreadBlock();

    public static boolean canBeGrass(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)world, blockpos));
        return i < world.m_7469_();
    }

    public static boolean canPropagate(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return Crustose.canBeGrass(state, world, pos) && !world.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    default public void randomCrustoseTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!Crustose.canBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.m_46597_(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)this.getUnspreadBlock().m_49966_()));
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (level.m_46803_(pos.m_7494_()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockState newState;
                    Block newBlock;
                    BlockPos offsetPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                    BlockState offsetState = level.m_8055_(offsetPos);
                    Object object = offsetState.m_60713_(Blocks.f_50493_) ? (Block)AtmosphericBlocks.CRUSTOSE.get() : (offsetState.m_60713_((Block)AtmosphericBlocks.ASPEN_LOG.get()) ? (Block)AtmosphericBlocks.CRUSTOSE_LOG.get() : (newBlock = offsetState.m_60713_((Block)AtmosphericBlocks.ASPEN_WOOD.get()) ? (Block)AtmosphericBlocks.CRUSTOSE_WOOD.get() : null));
                    if (newBlock == null || !Crustose.canPropagate(newState = BlockUtil.transferAllBlockStates((BlockState)level.m_8055_(offsetPos), (BlockState)newBlock.m_49966_()), (LevelReader)level, offsetPos)) continue;
                    level.m_46597_(offsetPos, newState);
                }
            }
        }
    }

    default public boolean isCrustoseValidBonemealTarget(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return level.m_8055_(pos.m_7494_()).m_60795_();
    }

    default public void performCrustoseBonemeal(Block block, ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.m_7494_();
        BlockState crustoseSprouts = ((Block)AtmosphericBlocks.GOLDEN_GROWTHS.get()).m_49966_();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos offsetPos = abovePos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.m_8055_((offsetPos = offsetPos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_7495_()).m_60713_(block) || level.m_8055_(offsetPos).m_60838_((BlockGetter)level, offsetPos)) continue block0;
            }
            if (!level.m_8055_(offsetPos).m_60795_() || !crustoseSprouts.m_60710_((LevelReader)level, offsetPos)) continue;
            level.m_7731_(offsetPos, crustoseSprouts, 3);
        }
    }
}

