/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.world.chunk_access;

import com.abdelaziz.canary.common.world.chunk.ChunkHolderExtended;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkCache.class})
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    private ServerChunkCache.MainThreadExecutor f_8332_;
    @Shadow
    @Final
    private DistanceManager f_8327_;
    @Shadow
    @Final
    public ChunkMap f_8325_;
    @Shadow
    @Final
    Thread f_8330_;
    private long time;
    private final long[] cacheKeys = new long[4];
    private final ChunkAccess[] cacheChunks = new ChunkAccess[4];

    @Shadow
    protected abstract ChunkHolder m_8364_(long var1);

    @Shadow
    protected abstract boolean m_8416_(ChunkHolder var1, int var2);

    @Shadow
    abstract boolean m_8489_();

    @Inject(method={"runDistanceManagerUpdates()Z"}, at={@At(value="HEAD")})
    private void preTick(CallbackInfoReturnable<Boolean> cir) {
        ++this.time;
    }

    @Overwrite
    public ChunkAccess m_7587_(int x, int z, ChunkStatus status, boolean create) {
        if (Thread.currentThread() != this.f_8330_) {
            return this.getChunkOffThread(x, z, status, create);
        }
        long[] cacheKeys = this.cacheKeys;
        long key = ServerChunkCacheMixin.createCacheKey(x, z, status);
        for (int i = 0; i < 4; ++i) {
            ChunkAccess chunk;
            if (key != cacheKeys[i] || (chunk = this.cacheChunks[i]) == null && create) continue;
            return chunk;
        }
        ChunkAccess chunk = this.getChunkBlocking(x, z, status, create);
        if (chunk != null) {
            this.addToCache(key, chunk);
        } else if (create) {
            throw new IllegalStateException("Chunk not there when requested");
        }
        return chunk;
    }

    private ChunkAccess getChunkOffThread(int x, int z, ChunkStatus status, boolean create) {
        return CompletableFuture.supplyAsync(() -> this.m_7587_(x, z, status, create), (Executor)this.f_8332_).join();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChunkAccess getChunkBlocking(int x, int z, ChunkStatus status, boolean create) {
        long key = ChunkPos.m_45589_((int)x, (int)z);
        int level = 33 + ChunkStatus.m_62370_((ChunkStatus)status);
        ChunkHolder holder = this.m_8364_(key);
        if (this.m_8416_(holder, level)) {
            if (!create) return null;
            this.createChunkLoadTicket(x, z, level);
            this.m_8489_();
            holder = this.m_8364_(key);
            if (this.m_8416_(holder, level)) {
                throw (IllegalStateException)Util.m_137570_((Throwable)new IllegalStateException("No chunk holder after ticket has been added"));
            }
        } else if (create && ((ChunkHolderExtended)holder).updateLastAccessTime(this.time)) {
            this.createChunkLoadTicket(x, z, level);
        }
        CompletableFuture loadFuture = null;
        CompletableFuture statusFuture = ((ChunkHolderExtended)holder).getFutureByStatus(status.m_62445_());
        if (statusFuture != null) {
            Either immediate = statusFuture.getNow(null);
            if (immediate != null) {
                Optional chunk = immediate.left();
                if (chunk.isPresent()) {
                    return (ChunkAccess)chunk.get();
                }
            } else {
                loadFuture = statusFuture;
            }
        }
        if (loadFuture == null) {
            if (ChunkHolder.m_140074_((int)holder.m_140093_()).m_62427_(status)) {
                CompletableFuture mergedFuture = this.f_8325_.m_140292_(holder, status);
                holder.m_143017_(mergedFuture, "schedule chunk status");
                ((ChunkHolderExtended)holder).setFutureForStatus(status.m_62445_(), mergedFuture);
                loadFuture = mergedFuture;
            } else {
                if (statusFuture == null) {
                    return null;
                }
                loadFuture = statusFuture;
            }
        }
        if (loadFuture.isDone()) return ((Either)loadFuture.join()).left().orElse(null);
        this.f_8332_.m_18701_(loadFuture::isDone);
        return ((Either)loadFuture.join()).left().orElse(null);
    }

    private void createChunkLoadTicket(int x, int z, int level) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        this.f_8327_.m_140792_(TicketType.f_9449_, chunkPos, level, (Object)chunkPos);
    }

    private static long createCacheKey(int chunkX, int chunkZ, ChunkStatus status) {
        return (long)chunkX & 0xFFFFFFFL | ((long)chunkZ & 0xFFFFFFFL) << 28 | (long)status.m_62445_() << 56;
    }

    private void addToCache(long key, ChunkAccess chunk) {
        for (int i = 3; i > 0; --i) {
            this.cacheKeys[i] = this.cacheKeys[i - 1];
            this.cacheChunks[i] = this.cacheChunks[i - 1];
        }
        this.cacheKeys[0] = key;
        this.cacheChunks[0] = chunk;
    }

    @Inject(method={"clearCache()V"}, at={@At(value="HEAD")})
    private void onCachesCleared(CallbackInfo ci) {
        Arrays.fill(this.cacheKeys, Long.MAX_VALUE);
        Arrays.fill(this.cacheChunks, null);
    }
}

