/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.hopper;

import com.abdelaziz.canary.common.hopper.CanaryDoubleInventory;
import com.abdelaziz.canary.common.hopper.CanaryStackList;
import com.abdelaziz.canary.common.hopper.ComparatorUpdatePattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HopperHelper {
    private static final VoxelShape CACHED_INPUT_VOLUME = Hopper.f_59298_;
    private static final AABB[] CACHED_INPUT_VOLUME_BOXES = CACHED_INPUT_VOLUME.m_83299_().toArray(new AABB[0]);

    public static AABB[] getHopperPickupVolumeBoxes(Hopper hopper) {
        VoxelShape inputAreaShape = hopper.m_59300_();
        if (inputAreaShape == CACHED_INPUT_VOLUME) {
            return CACHED_INPUT_VOLUME_BOXES;
        }
        return inputAreaShape.m_83299_().toArray(new AABB[0]);
    }

    @Nullable
    public static Container vanillaGetBlockInventory(Level world, BlockPos blockPos) {
        BlockEntity blockEntity;
        WorldlyContainer inventory = null;
        BlockState blockState = world.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            inventory = ((WorldlyContainerHolder)block).m_5840_(blockState, (LevelAccessor)world, blockPos);
        } else if (blockState.m_155947_() && (blockEntity = world.m_7702_(blockPos)) instanceof Container && (inventory = (Container)blockEntity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            inventory = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)blockState, (Level)world, (BlockPos)blockPos, (boolean)true);
        }
        return inventory;
    }

    public static boolean tryMoveSingleItem(Container to, ItemStack stack, @Nullable Direction fromDirection) {
        WorldlyContainer toSided;
        WorldlyContainer worldlyContainer = toSided = to instanceof WorldlyContainer ? (WorldlyContainer)to : null;
        if (toSided != null && fromDirection != null) {
            int[] slots = toSided.m_7071_(fromDirection);
            for (int slotIndex = 0; slotIndex < slots.length; ++slotIndex) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, slots[slotIndex], fromDirection)) continue;
                return true;
            }
        } else {
            int j = to.m_6643_();
            for (int slot = 0; slot < j; ++slot) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, slot, fromDirection)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean tryMoveSingleItem(Container to, @Nullable WorldlyContainer toSided, ItemStack transferStack, int targetSlot, @Nullable Direction fromDirection) {
        ItemStack toStack = to.m_8020_(targetSlot);
        if (to.m_7013_(targetSlot, transferStack) && (toSided == null || toSided.m_7155_(targetSlot, transferStack, fromDirection))) {
            if (toStack.m_41619_()) {
                ItemStack singleItem = transferStack.m_41620_(1);
                to.m_6836_(targetSlot, singleItem);
                return true;
            }
            if (toStack.m_150930_(transferStack.m_41720_())) {
                int toCount = toStack.m_41613_();
                if (toStack.m_41741_() > toCount && to.m_6893_() > toCount && ItemStack.m_41658_((ItemStack)toStack, (ItemStack)transferStack)) {
                    transferStack.m_41774_(1);
                    toStack.m_41769_(1);
                    return true;
                }
            }
        }
        return false;
    }

    private static int calculateReducedSignalStrength(float contentWeight, int inventorySize, int inventoryMaxCountPerStack, int numOccupiedSlots, int itemStackCount, int itemStackMaxCount) {
        int maxStackSize = Math.min(inventoryMaxCountPerStack, itemStackMaxCount);
        int newNumOccupiedSlots = numOccupiedSlots - (itemStackCount == 1 ? 1 : 0);
        float newContentWeight = contentWeight - 1.0f / (float)maxStackSize;
        return Mth.m_14143_((float)((newContentWeight /= (float)inventorySize) * 14.0f)) + (newNumOccupiedSlots > 0 ? 1 : 0);
    }

    public static ComparatorUpdatePattern determineComparatorUpdatePattern(Container from, CanaryStackList fromStackList) {
        int newSignalStrength;
        int fromSlot;
        ItemStack itemStack;
        if (from instanceof HopperBlockEntity || !(from instanceof RandomizableContainerBlockEntity)) {
            return ComparatorUpdatePattern.NO_UPDATE;
        }
        float contentWeight = 0.0f;
        int numOccupiedSlots = 0;
        for (int j = 0; j < from.m_6643_(); ++j) {
            ItemStack itemStack2 = from.m_8020_(j);
            if (itemStack2.m_41619_()) continue;
            int maxStackSize = Math.min(from.m_6893_(), itemStack2.m_41741_());
            contentWeight += (float)itemStack2.m_41613_() / (float)maxStackSize;
            ++numOccupiedSlots;
        }
        float f = contentWeight;
        int originalSignalStrength = Mth.m_14143_((float)((f /= (float)from.m_6643_()) * 14.0f)) + (numOccupiedSlots > 0 ? 1 : 0);
        ComparatorUpdatePattern updatePattern = ComparatorUpdatePattern.NO_UPDATE;
        int[] availableSlots = from instanceof WorldlyContainer ? ((WorldlyContainer)from).m_7071_(Direction.DOWN) : null;
        WorldlyContainer sidedInventory = from instanceof WorldlyContainer ? (WorldlyContainer)from : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.m_6643_();
        for (int i = 0; i < fromSize && ((itemStack = (ItemStack)fromStackList.get(fromSlot = availableSlots != null ? availableSlots[i] : i)).m_41619_() || sidedInventory != null && !sidedInventory.m_7157_(fromSlot, itemStack, Direction.DOWN) || (updatePattern = (newSignalStrength = HopperHelper.calculateReducedSignalStrength(contentWeight, from.m_6643_(), from.m_6893_(), numOccupiedSlots, itemStack.m_41613_(), itemStack.m_41741_())) != originalSignalStrength ? updatePattern.thenDecrementUpdateIncrementUpdate() : updatePattern.thenUpdate()).isChainable()); ++i) {
        }
        return updatePattern;
    }

    public static Container replaceDoubleInventory(Container blockInventory) {
        if (blockInventory instanceof CompoundContainer) {
            CompoundContainer doubleInventory = (CompoundContainer)blockInventory;
            if ((doubleInventory = CanaryDoubleInventory.getCanaryInventory(doubleInventory)) != null) {
                return doubleInventory;
            }
        }
        return blockInventory;
    }
}

