/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import umpaz.brewinandchewin.common.crafting.KegRecipe;
import umpaz.brewinandchewin.common.registry.BCItems;
import umpaz.brewinandchewin.common.utility.BCTextUtils;
import umpaz.brewinandchewin.integration.jei.BCJEIRecipeTypes;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FermentingRecipeCategory
implements IRecipeCategory<KegRecipe> {
    protected final IDrawableAnimated arrow;
    private final Component title = BCTextUtils.getTranslation("jei.fermenting", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable frigid;
    private final IDrawable cold;
    private final IDrawable warm;
    private final IDrawable hot;

    public FermentingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("brewinandchewin", "textures/gui/jei/keg.png");
        this.background = helper.createDrawable(backgroundImage, 29, 16, 117, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BCItems.KEG.get()));
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 28, 33, 9).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.frigid = helper.createDrawable(backgroundImage, 176, 0, 6, 3);
        this.cold = helper.createDrawable(backgroundImage, 182, 0, 7, 3);
        this.warm = helper.createDrawable(backgroundImage, 195, 0, 7, 3);
        this.hot = helper.createDrawable(backgroundImage, 202, 0, 7, 3);
    }

    public RecipeType<KegRecipe> getRecipeType() {
        return BCJEIRecipeTypes.FERMENTING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, KegRecipe recipe, IFocusGroup focusGroup) {
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        ItemStack resultStack = recipe.m_8043_();
        ItemStack containerStack = recipe.getOutputContainer();
        ItemStack fluidItemStack = ItemStack.f_41583_;
        if (!recipe.getFluidItem().m_43947_()) {
            recipeIngredients.remove(recipeIngredients.size() - 1);
            fluidItemStack = recipe.getFluidItem().m_43908_()[0];
        }
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                try {
                    builder.addSlot(RecipeIngredientRole.INPUT, column * borderSlotSize + 4, row * borderSlotSize + 12).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).m_43908_()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!fluidItemStack.m_41619_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 56, 2).addItemStack(fluidItemStack);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 7).addItemStack(resultStack);
        if (!containerStack.m_41619_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 39).addItemStack(containerStack);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 39).addItemStack(resultStack);
    }

    public void draw(KegRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 48, 28);
        if (recipe.getTemperature() == 1) {
            this.frigid.draw(matrixStack, 48, 23);
            this.cold.draw(matrixStack, 54, 23);
        }
        if (recipe.getTemperature() == 2) {
            this.cold.draw(matrixStack, 54, 23);
        }
        if (recipe.getTemperature() == 4) {
            this.warm.draw(matrixStack, 67, 23);
        }
        if (recipe.getTemperature() == 5) {
            this.hot.draw(matrixStack, 74, 23);
            this.warm.draw(matrixStack, 67, 23);
        }
    }
}

