/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import umpaz.brewinandchewin.client.gui.KegScreen;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.registry.BCItems;
import umpaz.brewinandchewin.common.registry.BCMenuTypes;
import umpaz.brewinandchewin.integration.jei.BCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.BCJEIRecipes;
import umpaz.brewinandchewin.integration.jei.category.FermentingRecipeCategory;
import umpaz.brewinandchewin.integration.jei.category.FlaxenCheeseRipeningCategory;
import umpaz.brewinandchewin.integration.jei.category.ScarletCheeseRipeningCategory;
import umpaz.brewinandchewin.integration.jei.resource.CheeseRipeningDummy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class BCJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("brewinandchewin", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FermentingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FlaxenCheeseRipeningCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ScarletCheeseRipeningCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        BCJEIRecipes modRecipes = new BCJEIRecipes();
        registration.addRecipes(BCJEIRecipeTypes.FERMENTING, modRecipes.getKegRecipes());
        registration.addRecipes(BCJEIRecipeTypes.FLAXEN_CHEESE_RIPENING, (List)ImmutableList.of((Object)new CheeseRipeningDummy()));
        registration.addRecipes(BCJEIRecipeTypes.SCARLET_CHEESE_RIPENING, (List)ImmutableList.of((Object)new CheeseRipeningDummy()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BCItems.KEG.get()), new RecipeType[]{BCJEIRecipeTypes.FERMENTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(KegScreen.class, 78, 45, 31, 7, new RecipeType[]{BCJEIRecipeTypes.FERMENTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(KegMenu.class, (MenuType)BCMenuTypes.KEG.get(), BCJEIRecipeTypes.FERMENTING, 0, 5, 9, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

