/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.recipebook.KegRecipeBookTab;
import umpaz.brewinandchewin.common.registry.BCItems;
import umpaz.brewinandchewin.common.registry.BCRecipeSerializers;
import umpaz.brewinandchewin.common.registry.BCRecipeTypes;

public class KegRecipe
implements Recipe<RecipeWrapper> {
    public static final int INPUT_SLOTS = 4;
    private final ResourceLocation id;
    private final String group;
    private final KegRecipeBookTab tab;
    private final NonNullList<Ingredient> inputItems;
    private final Ingredient fluidItem;
    private final ItemStack output;
    private final ItemStack container;
    private final float experience;
    private final int fermentTime;
    private final int temperature;

    public KegRecipe(ResourceLocation id, String group, @Nullable KegRecipeBookTab tab, NonNullList<Ingredient> inputItems, Ingredient fluidItem, ItemStack output, ItemStack container, float experience, int fermentTime, int temperature) {
        this.id = id;
        this.group = group;
        this.tab = tab;
        this.inputItems = inputItems;
        this.fluidItem = fluidItem;
        this.output = output;
        this.container = !container.m_41619_() ? container : (!output.getCraftingRemainingItem().m_41619_() ? output.getCraftingRemainingItem() : ItemStack.f_41583_);
        this.experience = experience;
        this.fermentTime = fermentTime;
        this.temperature = temperature;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    @Nullable
    public KegRecipeBookTab getRecipeBookTab() {
        return this.tab;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.addAll(this.inputItems);
        if (!this.fluidItem.m_43947_()) {
            ingredients.add((Object)this.fluidItem);
        }
        return ingredients;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ItemStack getOutputContainer() {
        return this.container;
    }

    public Ingredient getFluidItem() {
        return this.fluidItem;
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return this.output.m_41777_();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getFermentTime() {
        return this.fermentTime;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        if (this.fluidItem != null) {
            return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null && this.fluidItem.test(inv.m_8020_(4));
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BCRecipeSerializers.FERMENTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)BCRecipeTypes.FERMENTING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BCItems.KEG.get());
    }

    public static class Serializer
    implements RecipeSerializer<KegRecipe> {
        public KegRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String groupIn = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for fermenting recipe");
            }
            if (inputItemsIn.size() > 4) {
                throw new JsonParseException("Too many ingredients for fermenting recipe! The max is 4");
            }
            String tabKeyIn = GsonHelper.m_13851_((JsonObject)json, (String)"recipe_book_tab", null);
            KegRecipeBookTab tabIn = KegRecipeBookTab.findByName(tabKeyIn);
            if (tabKeyIn != null && tabIn == null) {
                BrewinAndChewin.LOGGER.warn("Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + EnumSet.allOf(KegRecipeBookTab.class));
            }
            Ingredient fluidItemIn = GsonHelper.m_13900_((JsonObject)json, (String)"fluiditem") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluiditem")) : Ingredient.f_43901_;
            ItemStack outputIn = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            ItemStack container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            float experienceIn = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int fermentTimeIn = GsonHelper.m_13824_((JsonObject)json, (String)"fermentingtime", (int)200);
            int temperatureIn = GsonHelper.m_13824_((JsonObject)json, (String)"temperature", (int)3);
            return new KegRecipe(recipeId, groupIn, tabIn, inputItemsIn, fluidItemIn, outputIn, container, experienceIn, fermentTimeIn, temperatureIn);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public KegRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String groupIn = buffer.m_130277_();
            KegRecipeBookTab tabIn = KegRecipeBookTab.findByName(buffer.m_130277_());
            int i = buffer.m_130242_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Ingredient fluidItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack outputIn = buffer.m_130267_();
            ItemStack container = buffer.m_130267_();
            float experienceIn = buffer.readFloat();
            int fermentTimeIn = buffer.m_130242_();
            int temperatureIn = buffer.m_130242_();
            return new KegRecipe(recipeId, groupIn, tabIn, (NonNullList<Ingredient>)inputItemsIn, fluidItem, outputIn, container, experienceIn, fermentTimeIn, temperatureIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, KegRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130070_(recipe.tab != null ? recipe.tab.toString() : "");
            buffer.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            recipe.fluidItem.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.m_130055_(recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.m_130130_(recipe.fermentTime);
            buffer.m_130130_(recipe.temperature);
        }
    }
}

