/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import umpaz.brewinandchewin.common.block.KegBlock;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.block.entity.inventory.KegItemHandler;
import umpaz.brewinandchewin.common.crafting.KegRecipe;
import umpaz.brewinandchewin.common.registry.BCBlockEntityTypes;
import umpaz.brewinandchewin.common.registry.BCItems;
import umpaz.brewinandchewin.common.registry.BCRecipeTypes;
import umpaz.brewinandchewin.common.tag.BCTags;
import umpaz.brewinandchewin.common.utility.BCTextUtils;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KegBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
Nameable,
RecipeHolder {
    public static final int FLUID_ITEM_INPUT_SLOT = 4;
    public static final int DRINK_DISPLAY_SLOT = 5;
    public static final int CONTAINER_SLOT = 6;
    public static final int OUTPUT_SLOT = 7;
    public static final int OUTPUT_CONTAINER_SLOT = 8;
    public static final int INVENTORY_SIZE = 9;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new KegItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new KegItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private int fermentTime;
    private int fermentTimeTotal;
    private ItemStack drinkContainerStack = ItemStack.f_41583_;
    private Component customName;
    private int kegTemperature;
    protected final ContainerData kegData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;

    public KegBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BCBlockEntityTypes.KEG.get(), pos, state);
    }

    public static ItemStack getDrinkFromItem(ItemStack kegStack) {
        CompoundTag inventoryTag;
        if (!kegStack.m_150930_((Item)BCItems.KEG.get())) {
            return ItemStack.f_41583_;
        }
        CompoundTag compound = kegStack.m_41737_("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            return handler.getStackInSlot(5);
        }
        return ItemStack.f_41583_;
    }

    public static void takeServingFromItem(ItemStack kegStack) {
        CompoundTag inventoryTag;
        if (!kegStack.m_150930_((Item)BCItems.KEG.get())) {
            return;
        }
        CompoundTag compound = kegStack.m_41737_("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            ItemStack newDrinkStack = handler.getStackInSlot(5);
            newDrinkStack.m_41774_(1);
            compound.m_128473_("Inventory");
            compound.m_128365_("Inventory", (Tag)handler.serializeNBT());
        }
    }

    public static ItemStack getContainerFromItem(ItemStack kegStack) {
        if (!kegStack.m_150930_((Item)BCItems.KEG.get())) {
            return ItemStack.f_41583_;
        }
        CompoundTag compound = kegStack.m_41737_("BlockEntityTag");
        if (compound != null) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        }
        return ItemStack.f_41583_;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.fermentTime = compound.m_128451_("FermentTime");
        this.fermentTimeTotal = compound.m_128451_("FermentTimeTotal");
        this.drinkContainerStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        this.kegTemperature = compound.m_128451_("Temperature");
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("FermentTime", this.fermentTime);
        compound.m_128405_("FermentTimeTotal", this.fermentTimeTotal);
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        compound.m_128405_("Temperature", this.kegTemperature);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag writeDrink(CompoundTag compound) {
        if (this.getDrink().m_41619_()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(9);
        for (int i = 0; i < 9; ++i) {
            drops.setStackInSlot(i, i == 5 ? this.inventory.getStackInSlot(i) : ItemStack.f_41583_);
        }
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)drops.serializeNBT());
        return compound;
    }

    public static void fermentingTick(Level level, BlockPos pos, BlockState state, KegBlockEntity keg) {
        boolean didInventoryChange = false;
        keg.updateTemperature();
        if (keg.hasInput()) {
            Optional<KegRecipe> recipe = keg.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)keg.inventory));
            if (recipe.isPresent() && keg.canFerment(recipe.get())) {
                didInventoryChange = keg.processFermenting(recipe.get(), keg);
            } else {
                keg.fermentTime = 0;
            }
        } else if (keg.fermentTimeTotal > 0) {
            keg.fermentTime = Mth.m_14045_((int)(keg.fermentTime - 2), (int)0, (int)keg.fermentTimeTotal);
        }
        ItemStack drinkStack = keg.getDrink();
        if (!drinkStack.m_41619_()) {
            if (!keg.doesDrinkHaveContainer(drinkStack)) {
                keg.moveDrinkToOutput();
                didInventoryChange = true;
            } else if (!keg.inventory.getStackInSlot(6).m_41619_()) {
                keg.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            keg.inventoryChanged();
        }
    }

    public void updateTemperature() {
        BlockState stateFurtherBelow;
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        int range = 1;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    states.add(this.f_58857_.m_8055_(this.f_58858_.m_7918_(x, y, z)));
                }
            }
        }
        int heat = states.stream().filter(s -> s.m_204336_(ModTags.HEAT_SOURCES)).filter(s -> s.m_61138_((Property)BlockStateProperties.f_61443_)).filter(s -> (Boolean)s.m_61143_((Property)BlockStateProperties.f_61443_)).mapToInt(s -> 1).sum();
        heat += states.stream().filter(s -> s.m_204336_(ModTags.HEAT_SOURCES)).filter(s -> !s.m_61138_((Property)BlockStateProperties.f_61443_)).mapToInt(s -> 1).sum();
        BlockState stateBelow = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        if (stateBelow.m_204336_(ModTags.HEAT_CONDUCTORS) && (stateFurtherBelow = this.f_58857_.m_8055_(this.f_58858_.m_6625_(2))).m_204336_(ModTags.HEAT_SOURCES)) {
            if (stateFurtherBelow.m_61138_((Property)BlockStateProperties.f_61443_)) {
                if (((Boolean)stateFurtherBelow.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                    ++heat;
                }
            } else {
                ++heat;
            }
        }
        int cold = states.stream().filter(s -> s.m_204336_(BCTags.FREEZE_SOURCES)).mapToInt(s -> 1).sum();
        float biomeTemperature = ((Biome)this.f_58857_.m_204166_(this.f_58858_).get()).m_47554_();
        if (biomeTemperature <= 0.0f) {
            cold += 2;
        } else if (biomeTemperature == 2.0f) {
            heat += 2;
        }
        this.kegTemperature = heat - cold;
        if (this.f_58857_.m_6042_().f_63857_()) {
            this.kegTemperature = 10;
        }
    }

    public int getTemperature() {
        if (this.kegTemperature < -4) {
            return 1;
        }
        if (this.kegTemperature < -1) {
            return 2;
        }
        if (this.kegTemperature < 2) {
            return 3;
        }
        if (this.kegTemperature < 5) {
            return 4;
        }
        return 5;
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, KegBlockEntity keg) {
    }

    private Optional<KegRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)BCRecipeTypes.FERMENTING.get()).get(this.lastRecipeID)) instanceof KegRecipe && recipe.m_5818_((Container)inventoryWrapper, this.f_58857_)) {
            return Optional.of((KegRecipe)recipe);
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)BCRecipeTypes.FERMENTING.get(), (Container)inventoryWrapper, this.f_58857_))).isPresent()) {
            this.lastRecipeID = ((KegRecipe)((Optional)recipe).get()).m_6423_();
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public ItemStack getContainer() {
        if (!this.drinkContainerStack.m_41619_()) {
            return this.drinkContainerStack;
        }
        return this.getDrink().getCraftingRemainingItem();
    }

    private boolean hasInput() {
        for (int i = 0; i < 5; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean canFerment(KegRecipe recipe) {
        int recipeTemp = recipe.getTemperature();
        if (this.hasInput() && (recipeTemp == 3 || recipeTemp == this.getTemperature())) {
            ItemStack resultStack = recipe.m_8043_();
            if (resultStack.m_41619_()) {
                return false;
            }
            ItemStack fluidStack = this.inventory.getStackInSlot(4);
            ItemStack storedContainerStack = this.inventory.getStackInSlot(8);
            if (!storedContainerStack.m_41619_() && !fluidStack.m_41720_().m_41469_().equals(storedContainerStack.m_41720_())) {
                return false;
            }
            if (storedContainerStack.m_41613_() >= storedContainerStack.m_41741_()) {
                return false;
            }
            ItemStack storedDrinkStack = this.inventory.getStackInSlot(5);
            if (storedDrinkStack.m_41619_()) {
                return true;
            }
            if (!storedDrinkStack.m_41656_(resultStack)) {
                return false;
            }
            if (storedDrinkStack.m_41613_() + resultStack.m_41613_() <= this.inventory.getSlotLimit(5)) {
                return true;
            }
            return storedDrinkStack.m_41613_() + resultStack.m_41613_() <= resultStack.m_41741_();
        }
        return false;
    }

    private boolean processFermenting(KegRecipe recipe, KegBlockEntity keg) {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.fermentTime;
        this.fermentTimeTotal = recipe.getFermentTime();
        if (this.fermentTime < this.fermentTimeTotal) {
            return false;
        }
        this.fermentTime = 0;
        this.drinkContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.m_8043_();
        ItemStack storedMealStack = this.inventory.getStackInSlot(5);
        if (storedMealStack.m_41619_()) {
            this.inventory.setStackInSlot(5, resultStack.m_41777_());
        } else if (storedMealStack.m_41656_(resultStack)) {
            storedMealStack.m_41769_(resultStack.m_41613_());
        }
        ItemStack storedContainers = this.inventory.getStackInSlot(8);
        ItemStack fluidStack = this.inventory.getStackInSlot(4);
        if (storedContainers.m_41619_()) {
            this.inventory.setStackInSlot(8, fluidStack.m_41777_().getCraftingRemainingItem());
            if (fluidStack.m_41613_() == 1) {
                this.inventory.setStackInSlot(4, ItemStack.f_41583_);
            } else {
                this.inventory.setStackInSlot(4, new ItemStack((ItemLike)fluidStack.m_41720_(), fluidStack.m_41613_() - 1));
            }
        } else if (storedContainers.m_41656_(this.inventory.getStackInSlot(4).getCraftingRemainingItem())) {
            storedContainers.m_41769_(resultStack.m_41613_());
            if (fluidStack.m_41613_() == 1) {
                this.inventory.setStackInSlot(4, ItemStack.f_41583_);
            } else {
                this.inventory.setStackInSlot(4, new ItemStack((ItemLike)fluidStack.m_41720_(), fluidStack.m_41613_() - 1));
            }
        }
        keg.m_6029_(recipe);
        for (int i = 0; i < 4; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                Direction direction = ((Direction)this.m_58900_().m_61143_((Property)KegBlock.FACING)).m_122428_();
                double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)this.f_58858_.m_123342_() + 0.7;
                double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(i).getCraftingRemainingItem(), (double)x, (double)y, (double)z, (double)((float)direction.m_122429_() * 0.08f), (double)0.25, (double)((float)direction.m_122431_() * 0.08f));
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player player) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.f_19853_, player.m_20182_());
        player.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                KegBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((KegRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getDrink() {
        return this.inventory.getStackInSlot(5);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 9; ++i) {
            if (i == 5) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveDrinkToOutput() {
        ItemStack drinkStack = this.inventory.getStackInSlot(5);
        ItemStack outputStack = this.inventory.getStackInSlot(7);
        int mealCount = Math.min(drinkStack.m_41613_(), drinkStack.m_41741_() - outputStack.m_41613_());
        if (outputStack.m_41619_()) {
            this.inventory.setStackInSlot(7, drinkStack.m_41620_(mealCount));
        } else if (outputStack.m_41720_() == drinkStack.m_41720_()) {
            drinkStack.m_41774_(mealCount);
            outputStack.m_41769_(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        ItemStack drinkStack = this.inventory.getStackInSlot(5);
        ItemStack containerInputStack = this.inventory.getStackInSlot(6);
        ItemStack outputStack = this.inventory.getStackInSlot(7);
        if (this.isContainerValid(containerInputStack) && outputStack.m_41613_() < outputStack.m_41741_()) {
            int smallerStackCount = Math.min(drinkStack.m_41613_(), containerInputStack.m_41613_());
            int drinkCount = Math.min(smallerStackCount, drinkStack.m_41741_() - outputStack.m_41613_());
            if (outputStack.m_41619_()) {
                containerInputStack.m_41774_(drinkCount);
                this.inventory.setStackInSlot(7, drinkStack.m_41620_(drinkCount));
            } else if (outputStack.m_41720_() == drinkStack.m_41720_()) {
                drinkStack.m_41774_(drinkCount);
                containerInputStack.m_41774_(drinkCount);
                outputStack.m_41769_(drinkCount);
            }
        }
    }

    public ItemStack useHeldItemOnDrink(ItemStack container) {
        if (this.isContainerValid(container) && !this.getDrink().m_41619_()) {
            container.m_41774_(1);
            return this.getDrink().m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    private boolean doesDrinkHaveContainer(ItemStack meal) {
        return !this.drinkContainerStack.m_41619_() || meal.hasCraftingRemainingItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.m_41619_()) {
            return false;
        }
        if (!this.drinkContainerStack.m_41619_()) {
            return this.drinkContainerStack.m_41656_(containerItem);
        }
        return this.getDrink().getCraftingRemainingItem().m_41656_(containerItem);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : BCTextUtils.getTranslation("container.keg", new Object[0]);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new KegMenu(id, player, this, this.kegData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 5) {
                    KegBlockEntity.this.checkNewRecipe = true;
                }
                KegBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> KegBlockEntity.this.fermentTime;
                    case 1 -> KegBlockEntity.this.fermentTimeTotal;
                    case 2 -> KegBlockEntity.this.kegTemperature;
                    case 3 -> KegBlockEntity.this.getTemperature();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        KegBlockEntity.this.fermentTime = value;
                        break;
                    }
                    case 1: {
                        KegBlockEntity.this.fermentTimeTotal = value;
                        break;
                    }
                    case 2: {
                        KegBlockEntity.this.kegTemperature = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }
}

