/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.items.IEldritch;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.AscensionAmulet;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;

public class EldritchAmulet
extends AscensionAmulet
implements IEldritch {
    public EldritchAmulet() {
        super(EldritchAmulet.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_(), "eldritch_amulet");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        String name = ItemNBTHelper.getString(stack, "Inscription", null);
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eldritchAmulet1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eldritchAmulet2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eldritchAmulet3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eldritchAmulet4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eldritchAmulet5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateWorthyOnesOnly(list);
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
            if (name != null) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletInscription", ChatFormatting.DARK_RED, name);
            }
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateCursedOnesOnly(list);
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        this.addAttributes(list, stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addAttributes(List<Component> list, ItemStack stack) {
        ItemLoreHelper.addLocalizedFormattedString(list, "curios.modifiers.charm", ChatFormatting.GOLD);
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eldritchAmuletStat1");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eldritchAmuletStat2");
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("f5bb82c7-0332-4adf-a414-2e4f03471983"), "enigmaticlegacy:attack_bonus", 3.0, AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    @Override
    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.f_19797_ % 5 == 0 && SuperpositionHandler.isTheWorthyOne((Player)player)) {
                List<LivingEntity> entities = SuperpositionHandler.getObservedEntities((Player)player, player.f_19853_, 3.0f, 128, false);
                for (LivingEntity entity : entities) {
                    ServerPlayer otherPlayer;
                    if (entity instanceof ServerPlayer && SuperpositionHandler.hasCurio((LivingEntity)(otherPlayer = (ServerPlayer)entity), this) && SuperpositionHandler.isTheWorthyOne((Player)otherPlayer)) continue;
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 1));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 10, 1));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 10, 1));
                }
            }
        }
    }

    @Override
    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    @Override
    public boolean canEquip(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return !SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticItems.ELDRITCH_AMULET) && SuperpositionHandler.isTheWorthyOne(player) && super.canEquip(context, stack);
        }
        return false;
    }

    private Map<String, NonNullList<ItemStack>> inventoryMap(Player player) {
        HashMap<String, NonNullList<ItemStack>> inventories = new HashMap<String, NonNullList<ItemStack>>();
        inventories.put("Armor", player.m_150109_().f_35975_);
        inventories.put("Main", player.m_150109_().f_35974_);
        inventories.put("Offhand", player.m_150109_().f_35976_);
        return inventories;
    }

    public void storeInventory(ServerPlayer player) {
        Map<String, NonNullList<ItemStack>> inventories = this.inventoryMap((Player)player);
        CompoundTag tag = new CompoundTag();
        inventories.entrySet().forEach(entry -> {
            ListTag list = new ListTag();
            for (int i = 0; i < ((NonNullList)entry.getValue()).size(); ++i) {
                ItemStack stack = (ItemStack)((NonNullList)entry.getValue()).get(i);
                if (EnchantmentHelper.m_44831_((ItemStack)stack).keySet().contains(Enchantments.f_44963_)) {
                    stack = ItemStack.f_41583_;
                }
                list.add((Object)stack.serializeNBT());
                ((NonNullList)entry.getValue()).set(i, (Object)ItemStack.f_41583_);
            }
            tag.m_128365_("Inventory" + (String)entry.getKey(), (Tag)list);
        });
        SuperpositionHandler.setPersistentTag((Player)player, "ELPersistentInventory", (Tag)tag);
    }

    public boolean reclaimInventory(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        Map<String, NonNullList<ItemStack>> inventories = this.inventoryMap((Player)newPlayer);
        Tag maybeTag = SuperpositionHandler.getPersistentTag((Player)oldPlayer, "ELPersistentInventory", null);
        boolean hadTag = false;
        if (maybeTag instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)maybeTag;
            SuperpositionHandler.removePersistentTag((Player)newPlayer, "ELPersistentInventory");
            hadTag = true;
            inventories.entrySet().forEach(entry -> {
                Tag maybeList = tag.m_128423_("Inventory" + (String)entry.getKey());
                if (maybeList instanceof ListTag) {
                    ListTag list = (ListTag)maybeList;
                    for (int i = 0; i < ((NonNullList)entry.getValue()).size(); ++i) {
                        CompoundTag stackTag = list.m_128728_(i);
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag);
                        ((NonNullList)entry.getValue()).set(i, (Object)stack);
                    }
                }
            });
        }
        return hadTag;
    }
}

