/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.crafting;

import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;

public class BindToPlayerRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<BindToPlayerRecipe> SERIALIZER = new SimpleRecipeSerializer(BindToPlayerRecipe::new);

    public BindToPlayerRecipe(ResourceLocation id) {
        super(id);
    }

    public ItemStack assemble(CraftingContainer inv) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack gem = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack slotStack = inv.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            stackList.add(slotStack);
        }
        if (stackList.size() == 1 && ((ItemStack)stackList.get(0)).m_41720_() instanceof IBound && gem != null && ItemNBTHelper.verifyExistance(gem, "BoundPlayer") && ItemNBTHelper.containsUUID(gem, "BoundUUID")) {
            ItemStack returned = ((ItemStack)stackList.get(0)).m_41777_();
            ItemNBTHelper.setString(returned, "BoundPlayer", ItemNBTHelper.getString(gem, "BoundPlayer", "Herobrine"));
            ItemNBTHelper.setUUID(returned, "BoundUUID", ItemNBTHelper.getUUID(gem, "BoundUUID", null));
            return returned;
        }
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack gem = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack slotStack = inv.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            stackList.add(slotStack);
        }
        return stackList.size() == 1 && ((ItemStack)stackList.get(0)).m_41720_() instanceof IBound && gem != null && ItemNBTHelper.verifyExistance(gem, "BoundPlayer") && ItemNBTHelper.containsUUID(gem, "BoundUUID");
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static interface IBound {
        @Nullable
        default public Player getBoundPlayer(Level world, ItemStack stack) {
            if (ItemNBTHelper.verifyExistance(stack, "BoundPlayer") && ItemNBTHelper.containsUUID(stack, "BoundUUID")) {
                UUID id = ItemNBTHelper.getUUID(stack, "BoundUUID", null);
                return world.m_46003_(id);
            }
            return null;
        }
    }
}

