/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.IElementalArmor;
import alexthw.ars_elemental.api.item.ISchoolBangle;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.blocks.ElementalSpellTurretTile;
import alexthw.ars_elemental.common.entity.FirenandoEntity;
import alexthw.ars_elemental.common.glyphs.EffectBubbleShield;
import alexthw.ars_elemental.common.items.armor.SummonPerk;
import alexthw.ars_elemental.common.mob_effects.EnthrallEffect;
import alexthw.ars_elemental.recipe.HeadCutRecipe;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.RegistryHelper;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityEvokerFangs;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_elemental")
public class DamageEvents {
    @SubscribeEvent
    public static void betterFilters(SpellDamageEvent.Pre event) {
        IFilter filter;
        Object e;
        if (event.context != null && event.context.getCurrentIndex() > 0 && (e = event.context.getSpell().recipe.get(event.context.getCurrentIndex() - 1)) instanceof IFilter && !(filter = (IFilter)e).shouldResolveOnEntity(event.target)) {
            event.setCanceled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void bypassRes(LivingAttackEvent event) {
        Entity focus;
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (living != null) {
                focus = ISchoolFocus.hasFocus((Entity)player);
                if (focus == null) return;
                switch (focus.getId()) {
                    case "fire": {
                        if (!event.getSource().m_19384_()) return;
                        if (!living.m_5825_()) {
                            if (!living.m_21023_(MobEffects.f_19607_)) return;
                        }
                        event.setCanceled(true);
                        DamageSource newDamage = new EntityDamageSource("hellflare", (Entity)player).m_19389_();
                        if (event.getSource().m_19376_()) {
                            newDamage.m_19380_();
                        }
                        if (event.getSource().m_19379_()) {
                            newDamage.m_19382_();
                        }
                        living.m_6469_(newDamage, event.getAmount());
                        return;
                    }
                    case "water": {
                        if (!event.getSource().m_19385_().equals("drown")) return;
                        if (living.m_6336_() != MobType.f_21644_) return;
                        event.setCanceled(true);
                        DamageSource newDamage = DamageSource.m_19344_((Player)player).m_19389_();
                        if (event.getSource().m_19376_()) {
                            newDamage.m_19380_();
                        }
                        if (event.getSource().m_19379_()) {
                            newDamage.m_19382_();
                        }
                        living.m_6469_(newDamage, event.getAmount());
                        return;
                    }
                }
                return;
            }
        }
        if (!((focus = event.getSource().m_7639_()) instanceof FirenandoEntity)) return;
        FirenandoEntity FE = (FirenandoEntity)focus;
        if (living instanceof Monster) {
            Monster mob = (Monster)living;
            if (!mob.m_5825_()) return;
            if (!event.getSource().m_19384_()) return;
            event.setCanceled(true);
            mob.m_6469_(DamageSource.m_19370_((LivingEntity)FE).m_19389_().m_19380_(), event.getAmount());
            return;
        }
        event.setCanceled(true);
        living.m_20095_();
    }

    @SubscribeEvent
    public static void banglesSpecials(LivingAttackEvent event) {
        Player player;
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            SpellSchool bangle;
            player = (Player)entity;
            if (living != null && living != player && (bangle = ISchoolBangle.hasBangle(event.getEntity().f_19853_, (Entity)player)) != null) {
                switch (bangle.getId()) {
                    case "fire": {
                        living.m_20254_(5);
                        break;
                    }
                    case "water": {
                        living.m_146917_(living.m_146888_() + 100);
                        break;
                    }
                    case "earth": {
                        living.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SNARE_EFFECT.get(), 60));
                    }
                }
            }
        }
        if (living instanceof Player) {
            player = (Player)living;
            if ((event.getSource() == DamageSource.f_19314_ || event.getSource() == DamageSource.f_19325_) && ISchoolBangle.hasBangle(event.getEntity().f_19853_, (Entity)player) == SpellSchools.ELEMENTAL_EARTH) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleHealing(LivingHealEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (((Boolean)ConfigHandler.COMMON.EnableGlyphEmpowering.get()).booleanValue() || (livingEntity = event.getEntity()) instanceof Player && ISchoolFocus.hasFocus((Entity)(player = (Player)livingEntity)) == SpellSchools.ELEMENTAL_EARTH) {
            event.setAmount(event.getAmount() * 1.5f);
        }
        if (event.getEntity().m_21023_((MobEffect)alexthw.ars_elemental.registry.ModPotions.FROZEN.get())) {
            event.setCanceled(true);
        }
        if (event.getEntity().m_21023_((MobEffect)alexthw.ars_elemental.registry.ModPotions.HELLFIRE.get())) {
            MobEffectInstance inst = event.getEntity().m_21124_((MobEffect)alexthw.ars_elemental.registry.ModPotions.HELLFIRE.get());
            if (inst == null) {
                return;
            }
            int amplifier = Math.min(9, inst.m_19564_());
            event.setAmount(event.getAmount() * (float)(10 - amplifier) / 10.0f);
            event.getEntity().f_19802_ = 0;
        }
    }

    @SubscribeEvent
    public static void damageTweaking(LivingHurtEvent event) {
        boolean not_bypassEnchants;
        Player player;
        int threadLevel;
        EntityEvokerFangs fangs;
        LivingEntity livingEntity;
        Entity entity;
        Entity dealer = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        SpellSchool focus = ISchoolFocus.hasFocus(dealer);
        if (dealer instanceof Player && focus != null) {
            switch (focus.getId()) {
                case "water": {
                    if (!(target.m_146889_() > 0.75f) || !event.getSource().m_19385_().equals("freeze")) break;
                    event.setAmount(event.getAmount() * 1.25f);
                    break;
                }
                case "air": {
                    if (!target.m_21023_(MobEffects.f_19620_) || !event.getSource().m_146707_()) break;
                    event.setAmount(event.getAmount() * 1.25f);
                }
            }
        }
        if ((entity = event.getSource().m_7639_()) instanceof EntityEvokerFangs && (livingEntity = (fangs = (EntityEvokerFangs)entity).m_36947_()) instanceof Player && (threadLevel = PerkUtil.countForPerk((IPerk)SummonPerk.INSTANCE, (Player)(player = (Player)livingEntity)) - 1) > 0) {
            event.setAmount(event.getAmount() + (float)threadLevel);
        }
        HashMap<SpellSchool, Integer> bonusMap = new HashMap<SpellSchool, Integer>();
        int bonusReduction = 0;
        if (target != null) {
            for (ItemStack stack : target.m_6168_()) {
                IElementalArmor armor;
                Item item = stack.m_41720_();
                if (!(item instanceof IElementalArmor) || !(armor = (IElementalArmor)item).doAbsorb(event.getSource())) continue;
                ++bonusReduction;
                if (bonusMap.containsKey(armor.getSchool())) {
                    bonusMap.put(armor.getSchool(), (Integer)bonusMap.get(armor.getSchool()) + 1);
                    continue;
                }
                bonusMap.put(armor.getSchool(), 1);
            }
        }
        boolean bl = not_bypassEnchants = !event.getSource().m_19379_();
        if (target instanceof Player) {
            LivingEntity living;
            Player player2 = (Player)target;
            Entity entity2 = event.getSource().m_7639_();
            if (entity2 instanceof LivingEntity && EnthrallEffect.isEnthralledBy(living = (LivingEntity)entity2, player2)) {
                event.setAmount(event.getAmount() * 0.5f);
            }
            if (not_bypassEnchants) {
                if (event.getSource() == DamageSource.f_19316_ && ISchoolFocus.hasFocus((Entity)player2) == SpellSchools.ELEMENTAL_AIR) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_FIRE, 0) == 4 && event.getSource().m_19384_() || event.getSource().f_19326_.equals("hellflare")) {
                    player2.m_20095_();
                    if (ISchoolFocus.hasFocus((Entity)player2) == SpellSchools.ELEMENTAL_FIRE) {
                        player2.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SPELL_DAMAGE_EFFECT.get(), 200, 2));
                    }
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_WATER, 0) == 4 && event.getSource() == DamageSource.f_19312_) {
                    player2.m_20301_(player2.m_6062_());
                    bonusReduction += 5;
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_EARTH, 0) == 4 && player2.m_146892_().m_7098_() < 20.0 && player2.m_36324_().m_38702_() < 2) {
                    player2.m_36324_().m_38705_(20);
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_AIR, 0) == 4 && event.getSource().m_146707_()) {
                    bonusReduction += 5;
                }
                if (bonusReduction > 0) {
                    int finalBonusReduction = bonusReduction;
                    CapabilityRegistry.getMana((LivingEntity)player2).ifPresent(mana -> {
                        if (finalBonusReduction > 3) {
                            mana.addMana((double)(event.getAmount() * 5.0f));
                        }
                        event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 200, finalBonusReduction / 2));
                    });
                }
            }
        }
        if (bonusReduction > 0 && not_bypassEnchants) {
            event.setAmount(event.getAmount() * (1.0f - (float)bonusReduction / 10.0f));
        }
        int ManaBubbleCost = (Integer)EffectBubbleShield.INSTANCE.GENERIC_INT.get();
        if (not_bypassEnchants && event.getEntity() != null && event.getEntity().m_21023_((MobEffect)alexthw.ars_elemental.registry.ModPotions.MANA_BUBBLE.get())) {
            LivingEntity living = event.getEntity();
            CapabilityRegistry.getMana((LivingEntity)event.getEntity()).ifPresent(mana -> {
                double maxReduction = mana.getCurrentMana() / (double)ManaBubbleCost;
                double amp = Math.min(1.0 + (double)living.m_21124_((MobEffect)alexthw.ars_elemental.registry.ModPotions.MANA_BUBBLE.get()).m_19564_() / 2.0, maxReduction);
                float newDamage = (float)Math.max(0.1, (double)event.getAmount() - amp);
                float actualReduction = event.getAmount() - newDamage;
                if (actualReduction > 0.0f && mana.getCurrentMana() >= (double)ManaBubbleCost) {
                    event.setAmount(newDamage);
                    mana.removeMana((double)(actualReduction * (float)ManaBubbleCost));
                }
                if (mana.getCurrentMana() < (double)ManaBubbleCost) {
                    living.m_21195_((MobEffect)alexthw.ars_elemental.registry.ModPotions.MANA_BUBBLE.get());
                }
            });
        }
    }

    @SubscribeEvent
    public static void statusProtect(MobEffectEvent.Applicable event) {
        if (event.getEntity().m_21023_((MobEffect)alexthw.ars_elemental.registry.ModPotions.MANA_BUBBLE.get()) && event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
            Optional effects = Registry.f_122823_.m_203431_(ModRegistry.MANABUBBLE_BLACKLIST);
            if (effects.isPresent() && ((HolderSet.Named)effects.get()).m_203614_().anyMatch(effect -> effect.get() == event.getEffectInstance().m_19544_())) {
                return;
            }
            int ManaBubbleCost = (Integer)EffectBubbleShield.INSTANCE.GENERIC_INT.get() * 2;
            if (event.getEntity().m_217043_().m_188503_(10) == 0) {
                CapabilityRegistry.getMana((LivingEntity)event.getEntity()).ifPresent(mana -> {
                    if (mana.getCurrentMana() >= (double)ManaBubbleCost) {
                        mana.removeMana((double)ManaBubbleCost / 2.0);
                        event.setResult(Event.Result.DENY);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void vorpalCut(SpellDamageEvent.Post event) {
        SpellSchool spellSchool;
        LivingEntity living;
        Entity entity = event.target;
        if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).m_21223_() > 0.0f) {
            return;
        }
        BlockEntity blockEntity = event.context.castingTile;
        if (blockEntity instanceof ElementalSpellTurretTile) {
            ElementalSpellTurretTile turret = (ElementalSpellTurretTile)blockEntity;
            spellSchool = turret.getSchool();
        } else {
            spellSchool = ISchoolFocus.hasFocus((Entity)event.caster);
        }
        SpellSchool school = spellSchool;
        Spell subspell = new Spell(event.context.getSpell().recipe.subList(event.context.getCurrentIndex() - 1, event.context.getSpell().recipe.size()));
        if (subspell.recipe.get(0) == EffectCut.INSTANCE && school == SpellSchools.ELEMENTAL_AIR) {
            ItemStack skull = null;
            int chance = 0;
            ResourceLocation mob = RegistryHelper.getRegistryName((EntityType)living.m_6095_());
            if (living instanceof Player) {
                Player player = (Player)living;
                GameProfile gameprofile = player.m_36316_();
                skull = new ItemStack((ItemLike)Items.f_42680_);
                chance = 20;
                skull.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gameprofile));
            } else {
                for (HeadCutRecipe recipe : living.m_9236_().m_7465_().m_44013_((RecipeType)ModRegistry.HEAD_CUT.get())) {
                    if (!recipe.mob.equals((Object)mob)) continue;
                    skull = recipe.result.m_41777_();
                    chance = recipe.chance;
                    break;
                }
            }
            if (skull == null) {
                return;
            }
            int looting = Math.min(3, subspell.getBuffsAtIndex(0, event.caster, (AbstractAugment)AugmentFortune.INSTANCE));
            for (int i = -1; i < looting; ++i) {
                if (living.m_217043_().m_188503_(100) > chance) continue;
                living.m_19983_(skull);
                break;
            }
        }
    }
}

