/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectConjureTerrain
extends ElementalAbstractEffect {
    public static EffectConjureTerrain INSTANCE = new EffectConjureTerrain();

    private EffectConjureTerrain() {
        super("conjure_terrain", "Conjure Terrain");
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockState toPlace;
        int amps = spellStats.getBuffCount((AbstractAugment)AugmentAmplify.INSTANCE);
        switch (amps) {
            default: {
                BlockState blockState = Blocks.f_50493_.m_49966_();
                break;
            }
            case 1: {
                BlockState blockState = Blocks.f_50652_.m_49966_();
                break;
            }
            case 2: {
                BlockState blockState = toPlace = Blocks.f_152551_.m_49966_();
            }
        }
        if (spellContext.hasNextPart()) {
            while (spellContext.hasNextPart()) {
                AbstractSpellPart next = spellContext.nextPart();
                if (!(next instanceof AbstractEffect)) continue;
                if (next == EffectConjureWater.INSTANCE) {
                    toPlace = Blocks.f_220864_.m_49966_();
                    break;
                }
                if (next == EffectCrush.INSTANCE) {
                    toPlace = amps > 0 ? Blocks.f_50062_.m_49966_() : Blocks.f_49992_.m_49966_();
                    break;
                }
                if (next == EffectSmelt.INSTANCE && amps > 0) {
                    toPlace = amps > 1 ? Blocks.f_152550_.m_49966_() : Blocks.f_50069_.m_49966_();
                    break;
                }
                spellContext.setCurrentIndex(spellContext.getCurrentIndex() - 1);
                break;
            }
        }
        GlyphEffectUtil.placeBlocks(rayTraceResult, world, shooter, spellStats, spellContext, resolver, toPlace);
    }

    public int getDefaultManaCost() {
        return 20;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentAmplify.INSTANCE});
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> map) {
        map.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
        return map;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.CONJURATION, SpellSchools.ELEMENTAL_EARTH});
    }

    public String getBookDescription() {
        return "Places terrain block at a location. Can place more blocks if augmented with AoE or Pierce";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }
}

