/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.summon;

import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SummonStrider
extends Strider
implements PlayerRideable,
ISummon {
    public int ticksLeft;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(SummonStrider.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public SummonStrider(EntityType<? extends Strider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SummonStrider(Level pLevel) {
        super((EntityType)ModEntities.STRIDER_SUMMON.get(), pLevel);
    }

    @NotNull
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.STRIDER_SUMMON.get();
    }

    public SummonStrider(SummonHorse oldHorse, Player summoner) {
        this(summoner.f_19853_);
        BlockPos position = oldHorse.m_20183_();
        this.m_6034_(position.m_123341_(), position.m_123342_(), position.m_123343_());
        this.ticksLeft = oldHorse.getTicksLeft();
        this.m_5853_(SoundSource.NEUTRAL);
        this.setOwnerID(summoner.m_20148_());
        oldHorse.m_21220_().stream().filter(e -> e.m_19544_().m_19486_()).forEach(arg_0 -> ((SummonStrider)this).m_7292_(arg_0));
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    protected boolean m_7341_(@NotNull Entity pEntity) {
        return pEntity instanceof Player;
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.m_20160_() && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float strafe = livingentity.f_20900_ * 0.5f;
                float steer = livingentity.f_20902_;
                if (steer <= 0.0f) {
                    steer *= 0.25f;
                }
                if (this.m_6109_()) {
                    this.m_7910_(this.m_33936_());
                    super.m_7760_(new Vec3((double)strafe, pTravelVector.f_82480_, (double)steer));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
            } else {
                super.m_7023_(pTravelVector);
            }
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (!player.f_19853_.m_5776_() && player.m_21205_().m_41619_() && !player.m_6144_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int m_213860_() {
        return 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.of(Util.f_137441_));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)this.m_20183_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.f_19853_, null, true);
            }
        }
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        this.onSummonDeath(this.f_19853_, cause, false);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksLeft = compound.m_128451_("left");
        UUID uuid = null;
        if (compound.m_128403_("owner")) {
            uuid = compound.m_128342_("owner");
        }
        if (uuid != null) {
            this.setOwnerID(uuid);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("left", this.ticksLeft);
        this.writeOwner(compound);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.m_20088_().m_135370_(OWNER_UUID)).isEmpty() ? this.m_20148_() : (UUID)((Optional)this.m_20088_().m_135370_(OWNER_UUID)).get();
    }

    public void setOwnerID(UUID uuid) {
        this.m_20088_().m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public Strider m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_6898_(@NotNull ItemStack pStack) {
        return false;
    }

    protected void m_5907_() {
    }

    public boolean m_7848_(@NotNull Animal pOtherAnimal) {
        return false;
    }

    public boolean m_35506_() {
        return false;
    }

    public boolean m_5957_() {
        return false;
    }
}

