/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.blocks.mermaid_block.MermaidTile;
import alexthw.ars_elemental.common.entity.ai.DolphinJumpGoal;
import alexthw.ars_elemental.common.entity.ai.FollowBoatGoalM;
import alexthw.ars_elemental.common.entity.ai.HybridStrollGoal;
import alexthw.ars_elemental.common.entity.ai.MermaidAi;
import alexthw.ars_elemental.common.entity.ai.MermaidChannelGoal;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class MermaidEntity
extends PathfinderMob
implements IAnimatable,
IAnimationListener,
IVariantColorProvider<MermaidEntity>,
IDispellable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final EntityDataAccessor<Boolean> CHANNELING = SynchedEntityData.m_135353_(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CHANNELING_ENTITY = SynchedEntityData.m_135353_(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> JUMPING = SynchedEntityData.m_135353_(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.m_135353_(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.m_135353_(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    public int channelCooldown;
    AnimationController<MermaidEntity> actions;
    int animTicks;
    boolean taming;
    static final RandomSource mermaidRandom = RandomSource.m_216343_();

    public MermaidEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.1f, 0.7f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_19793_ = 1.5f;
    }

    public MermaidEntity(Level level, boolean tamed) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.SIREN_ENTITY.get()), level);
        this.setTamed(tamed);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_149138_) {
        return MermaidAi.makeBrain((Brain<MermaidEntity>)this.m_5490_().m_22073_(p_149138_));
    }

    public Brain<MermaidEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HybridStrollGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new DolphinJumpGoal(this, 10));
        this.f_21345_.m_25352_(5, (Goal)new GoBackHomeGoal((Mob)this, this::getHome, 20, () -> this.getHome() != null));
        this.f_21345_.m_25352_(8, (Goal)new FollowBoatGoalM(this, () -> this.getHome() == null));
        this.f_21345_.m_25352_(5, (Goal)new MermaidChannelGoal(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.channelCooldown > 0) {
            --this.channelCooldown;
        }
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46467_() % 10L == 0L && this.m_7755_().getString().toLowerCase(Locale.ROOT).equals("jeb_")) {
            this.f_19804_.m_135381_(COLOR, (Object)Variants.random().toString());
        }
        if (this.f_19853_.f_46443_ && this.isChanneling() && this.getChannelEntity() != -1) {
            Entity entity = this.f_19853_.m_6815_(this.getChannelEntity());
            if (entity == null || entity.m_213877_()) {
                return;
            }
            Vec3 vec = entity.m_20182_();
            this.f_19853_.m_7106_(GlowParticleData.createData((ParticleColor)MermaidTile.shrineParticle), (double)((float)vec.f_82479_) - Math.sin((double)ClientInfo.ticksInGame / 8.0), (double)((float)vec.f_82480_) + Math.sin((double)ClientInfo.ticksInGame / 5.0) / 8.0 + 0.5, (double)((float)vec.f_82481_) - Math.cos((double)ClientInfo.ticksInGame / 8.0), 0.0, 0.0, 0.0);
        }
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_ && this.isTamed()) {
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Item)ModItems.SIREN_CHARM.get()).m_7968_()));
        }
        super.m_6667_(source);
    }

    public boolean m_6469_(@Nonnull DamageSource source, float p_70097_2_) {
        return SummonUtil.canSummonTakeDamage((DamageSource)source);
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    public int m_6062_() {
        return 6000;
    }

    public boolean m_6785_(double dist) {
        return !this.isTamed();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public int m_213860_() {
        return 0;
    }

    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.m_213877_()) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.isTamed()) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.SIREN_CHARM.get());
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
            ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)this.m_20183_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle", 0.0f, this::idle));
        this.actions = new AnimationController((IAnimatable)this, "actions", 10.0f, this::actions);
        data.addAnimationController(this.actions);
    }

    private PlayState idle(AnimationEvent<?> event) {
        if (this.f_19853_.f_46443_ && PatchouliHandler.isPatchouliWorld()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ground"));
            return PlayState.CONTINUE;
        }
        if (this.isJumping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jump"));
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().f_82480_ > 0.3) {
            this.setJump(true);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jump"));
        } else if (this.m_20096_() && !this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ground"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("floating"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState actions(AnimationEvent<?> event) {
        if (this.m_20184_().m_82553_() > 0.0 || this.f_19853_.f_46443_ && PatchouliHandler.isPatchouliWorld()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("swim"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeSupplier createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME, Optional.empty());
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(JUMPING, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)Variants.random().toString());
        this.f_19804_.m_135372_(CHANNELING, (Object)false);
        this.f_19804_.m_135372_(CHANNELING_ENTITY, (Object)-1);
    }

    public boolean isJumping() {
        return (Boolean)this.f_19804_.m_135370_(JUMPING);
    }

    public void setJump(boolean is) {
        this.f_19804_.m_135381_(JUMPING, (Object)is);
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(TAMED, (Object)tamed);
    }

    public void setHome(BlockPos home) {
        this.f_19804_.m_135381_(HOME, Optional.of(home));
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.f_19804_.m_135370_(HOME)).orElse(null);
    }

    @Nullable
    public MermaidTile getShrine() {
        BlockEntity blockEntity;
        BlockPos homePos = this.getHome();
        if (homePos == null || !((blockEntity = this.f_19853_.m_7702_(homePos)) instanceof MermaidTile)) {
            return null;
        }
        MermaidTile shrine = (MermaidTile)blockEntity;
        return shrine;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        NBTUtil.storeBlockPos((CompoundTag)tag, (String)"home", (BlockPos)this.getHome());
        tag.m_128379_("tamed", ((Boolean)this.f_19804_.m_135370_(TAMED)).booleanValue());
        tag.m_128359_("color", (String)this.f_19804_.m_135370_(COLOR));
        tag.m_128379_("channeling", ((Boolean)this.f_19804_.m_135370_(CHANNELING)).booleanValue());
        tag.m_128405_("cooldown", this.channelCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (NBTUtil.hasBlockPos((CompoundTag)tag, (String)"home")) {
            this.f_19804_.m_135381_(HOME, Optional.of(NBTUtil.getBlockPos((CompoundTag)tag, (String)"home")));
        }
        this.setTamed(tag.m_128471_("tamed"));
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128461_("color"));
        this.channelCooldown = tag.m_128451_("cooldown");
    }

    public int m_5792_() {
        return 3;
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(LevelAccessor levelAccessor, BlockPos pos) {
        int i = levelAccessor.m_5736_() + 10;
        int j = i - 30;
        boolean f1 = pos.m_123342_() >= j && pos.m_123342_() <= i;
        return f1 && levelAccessor.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && levelAccessor.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new MermaidPathNavigation<MermaidEntity>(this, pLevel);
    }

    public void startAnimation(int arg) {
    }

    public boolean isChanneling() {
        return (Boolean)this.f_19804_.m_135370_(CHANNELING);
    }

    public void setChanneling(boolean channeling) {
        this.f_19804_.m_135381_(CHANNELING, (Object)channeling);
    }

    public int getChannelEntity() {
        return (Integer)this.f_19804_.m_135370_(CHANNELING_ENTITY);
    }

    public void setChannelingEntity(int entityID) {
        this.f_19804_.m_135381_(CHANNELING_ENTITY, (Object)entityID);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    protected void m_8024_() {
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        MermaidAi.updateActivity(this);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isJumping() && this.animTicks <= 30) {
            ++this.animTicks;
        }
        if (this.animTicks > 30) {
            this.setJump(false);
            this.animTicks = 0;
            if (!this.isTamed() && this.taming) {
                this.taming = false;
                ItemStack stack = new ItemStack((ItemLike)ModItems.SIREN_SHARDS.get(), 1 + this.f_19853_.f_46441_.m_188503_(2));
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), stack));
                ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.POOF_MOB, (ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)this.m_20097_(), (int)10);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12052_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || pPlayer.m_20193_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.m_21120_(hand);
        if (this.isTamed()) {
            String color = Variants.getColorFromStack(stack);
            if (color != null && !this.getColor(this).equals(color)) {
                this.setColor(color, this);
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == Items.f_41868_ && !this.taming) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.8, 0.0));
            this.setJump(true);
            this.m_5834_();
            this.taming = true;
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(pPlayer, pVec, hand);
    }

    public String getColor(MermaidEntity mermaidEntity) {
        return (String)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(String color, MermaidEntity mermaidEntity) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public ResourceLocation getTexture(MermaidEntity entity) {
        return ArsElemental.prefix("textures/entity/mermaid_" + (this.getColor(entity).isEmpty() ? Variants.KELP.toString() : this.getColor(entity)) + ".png");
    }

    public static enum Variants {
        KELP,
        BUBBLE,
        FIRE,
        TUBE,
        HORN,
        BRAIN;


        public static String getColorFromStack(ItemStack stack) {
            if (stack.m_41720_() == Items.f_41910_) {
                return KELP.toString();
            }
            if (stack.m_41720_() == Items.f_42292_) {
                return BUBBLE.toString();
            }
            if (stack.m_41720_() == Items.f_42294_) {
                return HORN.toString();
            }
            if (stack.m_41720_() == Items.f_42290_) {
                return TUBE.toString();
            }
            if (stack.m_41720_() == Items.f_42293_) {
                return FIRE.toString();
            }
            if (stack.m_41720_() == Items.f_42291_) {
                return BRAIN.toString();
            }
            return null;
        }

        public static Variants random() {
            Map<Integer, Variants> ordinalMap = Arrays.stream(Variants.values()).collect(Collectors.toMap(Enum::ordinal, var -> var, (a, b) -> b));
            return ordinalMap.get(mermaidRandom.m_188503_(ordinalMap.size()));
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static class MermaidPathNavigation<E extends PathfinderMob>
    extends WaterBoundPathNavigation {
        public MermaidPathNavigation(E p_149218_, Level p_149219_) {
            super(p_149218_, p_149219_);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_149222_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_149222_);
        }

        public boolean m_6342_(BlockPos p_149224_) {
            return !this.f_26495_.m_8055_(p_149224_.m_7495_()).m_60795_();
        }
    }
}

