/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.api;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IPropagator {
    public static final AbstractAugment DUMMY = new AbstractAugment("dummy", "Dummy"){

        public int getDefaultManaCost() {
            return 0;
        }
    };

    default public void copyResolver(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        spellContext.setCanceled(true);
        Spell newSpell = spellContext.getRemainingSpell();
        if (newSpell.isEmpty()) {
            return;
        }
        newSpell.recipe.add(0, DUMMY);
        SpellContext newContext = spellContext.clone().withSpell(newSpell);
        SpellResolver newResolver = resolver.getNewResolver(newContext);
        this.propagate(world, rayTraceResult, shooter, stats, newResolver);
    }

    public void propagate(Level var1, HitResult var2, LivingEntity var3, SpellStats var4, SpellResolver var5);

    public static Vec3 adjustProjectileDirection(HitResult hitResult, LivingEntity shooter, SpellResolver resolver, Vec3 pos) {
        Vec3 direction;
        IWrappedCaster iWrappedCaster = resolver.spellContext.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tc = (TileCaster)iWrappedCaster;
            BlockEntity blockEntity = tc.getTile();
            if (blockEntity instanceof RotatingTurretTile) {
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                direction = rotatingTurretTile.getShootAngle();
            } else if (tc.getTile() instanceof RuneTile && hitResult instanceof EntityHitResult) {
                EntityHitResult ehr = (EntityHitResult)hitResult;
                direction = pos.m_82546_(ehr.m_82443_().m_20182_());
            } else {
                direction = new Vec3(((Direction)tc.getTile().m_58900_().m_61143_((Property)BasicSpellTurret.FACING)).m_122432_());
            }
        } else {
            direction = pos.m_82546_(shooter.m_20182_());
        }
        return direction;
    }
}

