/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.capability.BossCapability;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.extensions.IForgePlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={IForgePlayer.class})
public interface PlayerInteractDistScaling {
    @Shadow(remap=false)
    public boolean isCloseEnough(Entity var1, double var2);

    @Shadow(remap=false)
    public double getAttackRange();

    @Overwrite(remap=false)
    default public boolean canHit(Entity entity, double padding) {
        BossCapability cap = (BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null);
        if (cap != null && cap.isBoss()) {
            return this.isCloseEnough(entity, this.getAttackRange() * (double)cap.getBossType().getVisualScale() + padding);
        }
        return this.isCloseEnough(entity, this.getAttackRange() + padding);
    }
}

