/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.item;

import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigRequest;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class TaskScreenConfiguratorItem
extends Item {
    public TaskScreenConfiguratorItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(FTBQuests.ITEM_GROUP));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (level.m_7702_(ctx.m_8083_()) instanceof ITaskScreen) {
                TaskScreenConfiguratorItem.storeBlockPos(ctx.m_43722_(), ctx.m_43725_(), ctx.m_8083_());
                ctx.m_43723_().m_9236_().m_5594_(null, ctx.m_8083_(), SoundEvents.f_12211_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ctx.m_43723_().m_5661_((Component)Component.m_237110_((String)"ftbquests.message.configurator_bound", (Object[])new Object[]{TaskScreenConfiguratorItem.posToString(ctx.m_8083_())}), true);
            } else {
                return this.tryUseOn(sp, ctx.m_43722_()) ? InteractionResult.CONSUME : InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return this.tryUseOn(sp, stack) ? InteractionResultHolder.m_19096_((Object)stack) : InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237115_((String)"item.ftbquests.task_screen_configurator.tooltip").m_130940_(ChatFormatting.GRAY));
        TaskScreenConfiguratorItem.readBlockPos(itemStack).ifPresent(gPos -> {
            String str = gPos.m_122640_().m_135782_() + " / " + TaskScreenConfiguratorItem.posToString(gPos.m_122646_());
            list.add((Component)Component.m_237110_((String)"ftbquests.message.configurator_bound", (Object[])new Object[]{str}).m_130940_(ChatFormatting.DARK_AQUA));
        });
    }

    private boolean tryUseOn(ServerPlayer player, ItemStack stack) {
        return TaskScreenConfiguratorItem.readBlockPos(stack).map(gPos -> {
            ServerLevel level = player.m_20194_().m_129880_(gPos.m_122640_());
            if (level != player.m_9236_() || !player.m_9236_().m_46749_(gPos.m_122646_())) {
                player.m_5661_((Component)Component.m_237115_((String)"ftbquests.message.task_screen_inaccessible").m_130940_(ChatFormatting.RED), true);
                return false;
            }
            BlockEntity patt3666$temp = level.m_7702_(gPos.m_122646_());
            if (patt3666$temp instanceof ITaskScreen) {
                ITaskScreen taskScreen = (ITaskScreen)patt3666$temp;
                if (TaskScreenBlock.hasPermissionToEdit(player, taskScreen)) {
                    taskScreen.getCoreScreen().ifPresent(coreScreen -> new TaskScreenConfigRequest(coreScreen.m_58899_()).sendTo(player));
                    return true;
                }
                player.m_5661_((Component)Component.m_237115_((String)"block.ftbquests.screen.no_permission").m_130940_(ChatFormatting.RED), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"ftbquests.message.missing_task_screen").m_130940_(ChatFormatting.RED), true);
            }
            return false;
        }).orElse(false);
    }

    public static void storeBlockPos(ItemStack itemInHand, Level level, BlockPos clickedPos) {
        itemInHand.m_41784_().m_128356_("pos", clickedPos.m_121878_());
        itemInHand.m_41784_().m_128359_("dim", level.m_46472_().m_135782_().toString());
    }

    public static Optional<GlobalPos> readBlockPos(ItemStack stack) {
        if (stack.m_41720_() instanceof TaskScreenConfiguratorItem && stack.m_41782_() && stack.m_41783_().m_128441_("pos") && stack.m_41783_().m_128441_("dim")) {
            ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(stack.m_41783_().m_128461_("dim")));
            return Optional.of(GlobalPos.m_122643_((ResourceKey)dim, (BlockPos)BlockPos.m_122022_((long)stack.m_41783_().m_128454_("pos"))));
        }
        return Optional.empty();
    }

    private static String posToString(BlockPos pos) {
        return String.format("[%d,%d,%d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }
}

