/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.inventory.InputType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class HephaestusForgeInputLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static EnumMap<InputType, Map<Item, InputData>> inputs = new EnumMap(InputType.class);

    public HephaestusForgeInputLoader() {
        super(GSON, "hephaestus_forge/inputs");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        inputs.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            if (resourceLocation.m_135815_().startsWith("_")) continue;
            try {
                InputType type = InputType.valueOf(GsonHelper.m_13906_((JsonObject)entry.getValue().getAsJsonObject(), (String)"type").toUpperCase(Locale.ROOT));
                InputData data = this.deserializeInput(resourceLocation, entry.getValue().getAsJsonObject());
                inputs.computeIfAbsent(type, inputType -> new HashMap());
                inputs.get((Object)type).put(data.stack().m_41720_(), data);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                ForbiddenArcanus.LOGGER.error("Parsing error loading hephaestus forge input {}", (Object)resourceLocation, (Object)jsonParseException);
            }
        }
    }

    private static Map<InputType, Map<Item, InputData>> getInputs() {
        return inputs;
    }

    private InputData deserializeInput(ResourceLocation input, JsonObject jsonObject) {
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"item"));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item == null) {
            ForbiddenArcanus.LOGGER.error("Item " + resourceLocation + " does not exist.");
            throw new IllegalArgumentException();
        }
        int value = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"value");
        return new InputData(new ItemStack((ItemLike)item), value);
    }

    public static boolean isValidInput(InputType inputType, ItemStack stack) {
        return HephaestusForgeInputLoader.getInputs().containsKey((Object)inputType) && HephaestusForgeInputLoader.getInputs().get((Object)inputType).containsKey(stack.m_41720_());
    }

    public static InputData getInputData(InputType inputType, ItemStack stack) {
        return HephaestusForgeInputLoader.getInputs().get((Object)inputType).get(stack.m_41720_());
    }

    public static void setInputs(EnumMap<InputType, Map<Item, InputData>> inputTypeMapMap) {
        inputs = inputTypeMapMap;
    }

    public record InputData(ItemStack stack, int value) {
        public void serializeToNetwork(FriendlyByteBuf buffer) {
            buffer.m_130055_(this.stack);
            buffer.m_130130_(this.value);
        }

        public static InputData fromNetwork(FriendlyByteBuf buffer) {
            return new InputData(buffer.m_130267_(), buffer.m_130242_());
        }
    }
}

